/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.filter;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.filter.FilterPipe;
import java.util.NoSuchElementException;

public class RangeFilterPipe<S>
extends AbstractPipe<S, S>
implements FilterPipe<S> {
    private final int low;
    private final int high;
    private int counter = -1;

    public RangeFilterPipe(int low, int high) {
        this.low = low;
        this.high = high;
        if (this.low != -1 && this.high != -1 && this.low > this.high) {
            throw new IllegalArgumentException("Not a legal range: [" + low + ", " + high + "]");
        }
    }

    @Override
    protected S processNextStart() {
        do {
            Object s = this.starts.next();
            ++this.counter;
            if (this.low != -1 && this.counter < this.low || this.high != -1 && this.counter > this.high) continue;
            return (S)s;
        } while (this.high <= 0 || this.counter <= this.high);
        throw new NoSuchElementException();
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.low + "," + this.high + ")";
    }

    @Override
    public void reset() {
        this.counter = -1;
        super.reset();
    }
}

