/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.event;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Graph;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.event.EventEdge;
import com.tinkerpop.blueprints.pgm.impls.event.EventVertex;
import com.tinkerpop.blueprints.pgm.impls.event.listener.GraphChangedListener;
import com.tinkerpop.blueprints.pgm.impls.event.util.EventEdgeSequence;
import com.tinkerpop.blueprints.pgm.impls.event.util.EventVertexSequence;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EventGraph
implements Graph {
    protected final Graph graph;
    protected final List<GraphChangedListener> graphChangedListeners = new ArrayList<GraphChangedListener>();

    public EventGraph(Graph graph) {
        this.graph = graph;
    }

    public void removeAllListeners() {
        this.graphChangedListeners.clear();
    }

    public void addListener(GraphChangedListener listener) {
        this.graphChangedListeners.add(listener);
    }

    public Iterator<GraphChangedListener> getListenerIterator() {
        return this.graphChangedListeners.iterator();
    }

    public void removeListener(GraphChangedListener listener) {
        this.graphChangedListeners.remove(listener);
    }

    protected void onVertexAdded(Vertex vertex) {
        for (GraphChangedListener listener : this.graphChangedListeners) {
            listener.vertexAdded(vertex);
        }
    }

    protected void onVertexRemoved(Vertex vertex) {
        for (GraphChangedListener listener : this.graphChangedListeners) {
            listener.vertexRemoved(vertex);
        }
    }

    protected void onEdgeAdded(Edge edge) {
        for (GraphChangedListener listener : this.graphChangedListeners) {
            listener.edgeAdded(edge);
        }
    }

    protected void onEdgeRemoved(Edge edge) {
        for (GraphChangedListener listener : this.graphChangedListeners) {
            listener.edgeRemoved(edge);
        }
    }

    protected void onGraphCleared() {
        for (GraphChangedListener listener : this.graphChangedListeners) {
            listener.graphCleared();
        }
    }

    @Override
    public Vertex addVertex(Object id) {
        Vertex vertex = this.graph.addVertex(id);
        if (vertex == null) {
            return null;
        }
        this.onVertexAdded(vertex);
        return new EventVertex(vertex, this.graphChangedListeners);
    }

    @Override
    public Vertex getVertex(Object id) {
        Vertex vertex = this.graph.getVertex(id);
        if (vertex == null) {
            return null;
        }
        return new EventVertex(vertex, this.graphChangedListeners);
    }

    @Override
    public void removeVertex(Vertex vertex) {
        Vertex vertexToRemove = vertex;
        if (vertex instanceof EventVertex) {
            vertexToRemove = ((EventVertex)vertex).getRawVertex();
        }
        this.graph.removeVertex(vertexToRemove);
        this.onVertexRemoved(vertex);
    }

    @Override
    public Iterable<Vertex> getVertices() {
        return new EventVertexSequence(this.graph.getVertices().iterator(), this.graphChangedListeners);
    }

    @Override
    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        Edge edge = this.graph.addEdge(id, outVertex, inVertex, label);
        if (edge == null) {
            return null;
        }
        return new EventEdge(edge, this.graphChangedListeners);
    }

    @Override
    public Edge getEdge(Object id) {
        Edge edge = this.graph.getEdge(id);
        if (edge == null) {
            return null;
        }
        this.onEdgeAdded(edge);
        return new EventEdge(edge, this.graphChangedListeners);
    }

    @Override
    public void removeEdge(Edge edge) {
        Edge edgeToRemove = edge;
        if (edge instanceof EventEdge) {
            edgeToRemove = ((EventEdge)edge).getRawEdge();
        }
        this.graph.removeEdge(edgeToRemove);
        this.onEdgeRemoved(edge);
    }

    @Override
    public Iterable<Edge> getEdges() {
        return new EventEdgeSequence(this.graph.getEdges().iterator(), this.graphChangedListeners);
    }

    @Override
    public void clear() {
        this.graph.clear();
        this.onGraphCleared();
    }

    @Override
    public void shutdown() {
        this.graph.shutdown();
    }

    public String toString() {
        return "(event)" + this.graph.toString();
    }

    public Graph getRawGraph() {
        return this.graph;
    }
}

