/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util.graphml;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Graph;
import com.tinkerpop.blueprints.pgm.TransactionalGraph;
import com.tinkerpop.blueprints.pgm.Vertex;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class GraphMLReader {
    private final Graph graph;
    private String vertexIdKey = null;
    private String edgeIdKey = null;
    private String edgeLabelKey = null;

    public GraphMLReader(Graph graph) {
        this.graph = graph;
    }

    public void setVertexIdKey(String vertexIdKey) {
        this.vertexIdKey = vertexIdKey;
    }

    public void setEdgeIdKey(String edgeIdKey) {
        this.edgeIdKey = edgeIdKey;
    }

    public void setEdgeLabelKey(String edgeLabelKey) {
        this.edgeLabelKey = edgeLabelKey;
    }

    public void inputGraph(InputStream graphMLInputStream) throws XMLStreamException {
        GraphMLReader.inputGraph(this.graph, graphMLInputStream, 1000, this.vertexIdKey, this.edgeIdKey, this.edgeLabelKey);
    }

    public void inputGraph(InputStream graphMLInputStream, int bufferSize) throws XMLStreamException {
        GraphMLReader.inputGraph(this.graph, graphMLInputStream, bufferSize, this.vertexIdKey, this.edgeIdKey, this.edgeLabelKey);
    }

    public static void inputGraph(Graph graph, InputStream graphMLInputStream) throws XMLStreamException {
        GraphMLReader.inputGraph(graph, graphMLInputStream, 1000, null, null, null);
    }

    public static void inputGraph(Graph graph, InputStream graphMLInputStream, int bufferSize, String vertexIdKey, String edgeIdKey, String edgeLabelKey) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLStreamReader reader = inputFactory.createXMLStreamReader(graphMLInputStream);
        HashMap<String, String> keyIdMap = new HashMap<String, String>();
        HashMap<String, String> keyTypesMaps = new HashMap<String, String>();
        HashMap<String, Object> vertexIdMap = new HashMap<String, Object>();
        HashMap<String, Object> vertexMappedIdMap = new HashMap<String, Object>();
        Object vertexId = null;
        HashMap<String, Object> vertexProps = null;
        boolean inVertex = false;
        Object edgeId = null;
        Object edgeLabel = null;
        Vertex edgeInVertex = null;
        Vertex edgeOutVertex = null;
        HashMap<String, Object> edgeProps = null;
        boolean inEdge = false;
        TransactionalGraph.Mode transactionMode = null;
        boolean isTransactionalGraph = false;
        Integer transactionBufferSize = 0;
        if (bufferSize > 0 && graph instanceof TransactionalGraph) {
            transactionMode = ((TransactionalGraph)graph).getTransactionMode();
            ((TransactionalGraph)graph).setTransactionMode(TransactionalGraph.Mode.MANUAL);
            ((TransactionalGraph)graph).startTransaction();
            isTransactionalGraph = true;
        }
        while (reader.hasNext()) {
            Object value;
            Integer n;
            Integer n2;
            Integer inObjectId;
            String elementName;
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                String key;
                String attributeName;
                elementName = reader.getName().getLocalPart();
                if (elementName.equals("key")) {
                    String id = reader.getAttributeValue(null, "id");
                    attributeName = reader.getAttributeValue(null, "attr.name");
                    String attributeType = reader.getAttributeValue(null, "attr.type");
                    keyIdMap.put(id, attributeName);
                    keyTypesMaps.put(attributeName, attributeType);
                } else if (elementName.equals("node")) {
                    vertexId = reader.getAttributeValue(null, "id");
                    if (vertexIdKey != null) {
                        vertexMappedIdMap.put((String)vertexId, vertexId);
                    }
                    inVertex = true;
                    vertexProps = new HashMap<String, Object>();
                } else if (elementName.equals("edge")) {
                    edgeId = reader.getAttributeValue(null, "id");
                    edgeLabel = reader.getAttributeValue(null, "label");
                    edgeLabel = edgeLabel == null ? "_default" : edgeLabel;
                    String outVertexId = reader.getAttributeValue(null, "source");
                    String inVertexId = reader.getAttributeValue(null, "target");
                    Object outObjectId = null;
                    inObjectId = null;
                    if (vertexIdKey == null) {
                        outObjectId = vertexIdMap.get(outVertexId);
                        inObjectId = vertexIdMap.get(inVertexId);
                    } else {
                        outObjectId = vertexIdMap.get(vertexMappedIdMap.get(outVertexId));
                        inObjectId = vertexIdMap.get(vertexMappedIdMap.get(inVertexId));
                    }
                    edgeOutVertex = null;
                    if (null != outObjectId) {
                        edgeOutVertex = graph.getVertex(outObjectId);
                    }
                    edgeInVertex = null;
                    if (null != inObjectId) {
                        edgeInVertex = graph.getVertex(inObjectId);
                    }
                    if (null == edgeOutVertex) {
                        edgeOutVertex = graph.addVertex(outVertexId);
                        n2 = transactionBufferSize;
                        n = transactionBufferSize = Integer.valueOf(transactionBufferSize + 1);
                        vertexIdMap.put(outVertexId, edgeOutVertex.getId());
                        if (vertexIdKey != null) {
                            vertexMappedIdMap.put(outVertexId, outVertexId);
                        }
                    }
                    if (null == edgeInVertex) {
                        edgeInVertex = graph.addVertex(inVertexId);
                        n2 = transactionBufferSize;
                        n = transactionBufferSize = Integer.valueOf(transactionBufferSize + 1);
                        vertexIdMap.put(inVertexId, edgeInVertex.getId());
                        if (vertexIdKey != null) {
                            vertexMappedIdMap.put(inVertexId, inVertexId);
                        }
                    }
                    inEdge = true;
                    edgeProps = new HashMap<String, Object>();
                } else if (elementName.equals("data") && (attributeName = (String)keyIdMap.get(key = reader.getAttributeValue(null, "key"))) != null) {
                    value = reader.getElementText();
                    if (inVertex) {
                        if (vertexIdKey != null && key.equals(vertexIdKey)) {
                            vertexMappedIdMap.put((String)vertexId, value);
                            vertexId = value;
                        } else {
                            vertexProps.put(key, GraphMLReader.typeCastValue(key, (String)value, keyTypesMaps));
                        }
                    } else if (inEdge) {
                        if (edgeLabelKey != null && key.equals(edgeLabelKey)) {
                            edgeLabel = value;
                        } else if (edgeIdKey != null && key.equals(edgeIdKey)) {
                            edgeId = value;
                        } else {
                            edgeProps.put(key, GraphMLReader.typeCastValue(key, (String)value, keyTypesMaps));
                        }
                    }
                }
            } else if (eventType.equals(2)) {
                Object currentVertex;
                elementName = reader.getName().getLocalPart();
                if (elementName.equals("node")) {
                    Object vertexObjectId = vertexIdMap.get(vertexId);
                    if (vertexObjectId != null) {
                        currentVertex = graph.getVertex(vertexObjectId);
                    } else {
                        currentVertex = graph.addVertex(vertexId);
                        value = transactionBufferSize;
                        inObjectId = transactionBufferSize = Integer.valueOf(transactionBufferSize + 1);
                        vertexIdMap.put((String)vertexId, currentVertex.getId());
                    }
                    for (Map.Entry prop : vertexProps.entrySet()) {
                        currentVertex.setProperty((String)prop.getKey(), prop.getValue());
                        n2 = transactionBufferSize;
                        n = transactionBufferSize = Integer.valueOf(transactionBufferSize + 1);
                    }
                    vertexId = null;
                    vertexProps = null;
                    inVertex = false;
                } else if (elementName.equals("edge")) {
                    Edge currentEdge = graph.addEdge(edgeId, edgeOutVertex, edgeInVertex, (String)edgeLabel);
                    currentVertex = transactionBufferSize;
                    transactionBufferSize = transactionBufferSize + 1;
                    Integer i$ = transactionBufferSize;
                    for (Map.Entry prop : edgeProps.entrySet()) {
                        currentEdge.setProperty((String)prop.getKey(), prop.getValue());
                        Integer n3 = transactionBufferSize;
                        n2 = transactionBufferSize = Integer.valueOf(transactionBufferSize + 1);
                    }
                    edgeId = null;
                    edgeLabel = null;
                    edgeInVertex = null;
                    edgeOutVertex = null;
                    edgeProps = null;
                    inEdge = false;
                }
            }
            if (!isTransactionalGraph || transactionBufferSize <= bufferSize) continue;
            ((TransactionalGraph)graph).stopTransaction(TransactionalGraph.Conclusion.SUCCESS);
            ((TransactionalGraph)graph).startTransaction();
            transactionBufferSize = 0;
        }
        reader.close();
        if (isTransactionalGraph) {
            ((TransactionalGraph)graph).stopTransaction(TransactionalGraph.Conclusion.SUCCESS);
            ((TransactionalGraph)graph).setTransactionMode(transactionMode);
        }
    }

    private static Object typeCastValue(String key, String value, Map<String, String> keyTypes) {
        String type = keyTypes.get(key);
        if (null == type || type.equals("string")) {
            return value;
        }
        if (type.equals("float")) {
            return Float.valueOf(value);
        }
        if (type.equals("int")) {
            return Integer.valueOf(value);
        }
        if (type.equals("double")) {
            return Double.valueOf(value);
        }
        if (type.equals("boolean")) {
            return Boolean.valueOf(value);
        }
        if (type.equals("long")) {
            return Long.valueOf(value);
        }
        return value;
    }
}

