/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util.json;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.Vertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JSONWriter {
    private static JSONArray createJSONList(List list, List<String> propertyKeys, boolean showTypes) throws JSONException {
        JSONArray jsonList = new JSONArray();
        for (Object item : list) {
            if (item instanceof Element) {
                jsonList.put((Object)JSONWriter.createJSONElement((Element)item, propertyKeys, showTypes));
                continue;
            }
            if (item instanceof List) {
                jsonList.put((Object)JSONWriter.createJSONList((List)item, propertyKeys, showTypes));
                continue;
            }
            if (item instanceof Map) {
                jsonList.put((Object)JSONWriter.createJSONMap((Map)item, propertyKeys, showTypes));
                continue;
            }
            if (item.getClass().isArray()) {
                jsonList.put((Object)JSONWriter.createJSONList(JSONWriter.convertArrayToList(item), propertyKeys, showTypes));
                continue;
            }
            jsonList.put(item);
        }
        return jsonList;
    }

    private static JSONObject createJSONMap(Map map, List<String> propertyKeys, boolean showTypes) throws JSONException {
        JSONObject jsonMap = new JSONObject();
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof List) {
                value = JSONWriter.createJSONList((List)value, propertyKeys, showTypes);
            } else if (value instanceof Map) {
                value = JSONWriter.createJSONMap((Map)value, propertyKeys, showTypes);
            } else if (value instanceof Element) {
                value = JSONWriter.createJSONElement((Element)value, propertyKeys, showTypes);
            } else if (value.getClass().isArray()) {
                value = JSONWriter.createJSONList(JSONWriter.convertArrayToList(value), propertyKeys, showTypes);
            }
            jsonMap.put(key.toString(), JSONWriter.getValue(value, showTypes));
        }
        return jsonMap;
    }

    public static JSONObject createJSONElement(Element element) {
        return JSONWriter.createJSONElement(element, null, false);
    }

    public static JSONObject createJSONElement(Element element, List<String> propertyKeys, boolean showTypes) {
        JSONObject jsonElement = new JSONObject();
        try {
            jsonElement = JSONWriter.createJSONMap(JSONWriter.createPropertyMap(element, propertyKeys), propertyKeys, showTypes);
            jsonElement.put("_id", element.getId());
            if (element instanceof Vertex) {
                jsonElement.put("_type", (Object)"vertex");
            } else if (element instanceof Edge) {
                Edge edge = (Edge)element;
                jsonElement.put("_type", (Object)"edge");
                jsonElement.put("_outV", edge.getOutVertex().getId());
                jsonElement.put("_inV", edge.getInVertex().getId());
                jsonElement.put("_label", (Object)edge.getLabel());
            }
        }
        catch (JSONException jsone) {
            // empty catch block
        }
        return jsonElement;
    }

    private static Map createPropertyMap(Element element, List<String> propertyKeys) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (propertyKeys == null) {
            for (String key : element.getPropertyKeys()) {
                map.put(key, element.getProperty(key));
            }
        } else {
            for (String key : propertyKeys) {
                Object valToPutInMap = element.getProperty(key);
                if (valToPutInMap == null) continue;
                map.put(key, valToPutInMap);
            }
        }
        return map;
    }

    private static Object getValue(Object value, boolean includeType) throws JSONException {
        Object returnValue = value;
        String type = JSONWriter.determineType(value);
        if (includeType) {
            JSONObject valueAndType = new JSONObject();
            valueAndType.put("type", (Object)type);
            if (type.equals("list")) {
                JSONArray list = (JSONArray)value;
                for (int ix = 0; ix < list.length(); ++ix) {
                    valueAndType.accumulate("value", JSONWriter.getValue(list.get(ix), includeType));
                }
            } else if (type.equals("map")) {
                JSONObject convertedMap = new JSONObject();
                JSONObject jsonObject = (JSONObject)value;
                Iterator keyIterator = jsonObject.keys();
                while (keyIterator.hasNext()) {
                    Object key = keyIterator.next();
                    convertedMap.put(key.toString(), jsonObject.get(key.toString()));
                }
                valueAndType.put("value", (Object)convertedMap);
            } else {
                valueAndType.put("value", value);
            }
            returnValue = valueAndType;
        }
        return returnValue;
    }

    private static List convertArrayToList(Object value) {
        List<Object> list = new ArrayList<Number>();
        if (value instanceof int[]) {
            int[] arr = (int[])value;
            for (int ix = 0; ix < arr.length; ++ix) {
                list.add(arr[ix]);
            }
        } else if (value instanceof double[]) {
            double[] arr = (double[])value;
            for (int ix = 0; ix < arr.length; ++ix) {
                list.add(arr[ix]);
            }
        } else if (value instanceof float[]) {
            float[] arr = (float[])value;
            for (int ix = 0; ix < arr.length; ++ix) {
                list.add(Float.valueOf(arr[ix]));
            }
        } else if (value instanceof long[]) {
            long[] arr = (long[])value;
            for (int ix = 0; ix < arr.length; ++ix) {
                list.add(arr[ix]);
            }
        } else if (value instanceof boolean[]) {
            boolean[] arr = (boolean[])value;
            for (int ix = 0; ix < arr.length; ++ix) {
                list.add(arr[ix]);
            }
        } else {
            list = Arrays.asList((Object[])value);
        }
        return list;
    }

    private static String determineType(Object value) {
        String type = "string";
        if (value instanceof Double) {
            type = "double";
        } else if (value instanceof Float) {
            type = "float";
        } else if (value instanceof Integer) {
            type = "integer";
        } else if (value instanceof Long) {
            type = "long";
        } else if (value instanceof Boolean) {
            type = "boolean";
        } else if (value instanceof JSONArray) {
            type = "list";
        } else if (value instanceof JSONObject) {
            type = "map";
        }
        return type;
    }
}

