/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.centrality;

import java.util.Set;
import org.neo4j.graphalgo.CostAccumulator;
import org.neo4j.graphalgo.impl.centrality.CostDivider;
import org.neo4j.graphalgo.impl.centrality.ShortestPathBasedCentrality;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPath;
import org.neo4j.graphdb.Node;

public class ClosenessCentrality<ShortestPathCostType>
extends ShortestPathBasedCentrality<ShortestPathCostType, ShortestPathCostType> {
    CostDivider<ShortestPathCostType> centralityDivider;

    public ClosenessCentrality(SingleSourceShortestPath<ShortestPathCostType> singleSourceShortestPath, CostAccumulator<ShortestPathCostType> centralityAccumulator, ShortestPathCostType zeroValue, Set<Node> nodeSet, CostDivider<ShortestPathCostType> centralityDivider) {
        super(singleSourceShortestPath, centralityAccumulator, zeroValue, nodeSet);
        this.centralityDivider = centralityDivider;
    }

    @Override
    public ShortestPathCostType getCentrality(Node node) {
        Object centrality = this.centralities.get(node);
        if (centrality == null) {
            return null;
        }
        if (centrality.equals(this.zeroValue)) {
            this.singleSourceShortestPath.reset();
            this.singleSourceShortestPath.setStartNode(node);
            this.processShortestPaths(node, this.singleSourceShortestPath);
        }
        return (ShortestPathCostType)this.centralities.get(node);
    }

    @Override
    public void processShortestPaths(Node node, SingleSourceShortestPath<ShortestPathCostType> singleSourceShortestPath) {
        Object shortestPathSum = null;
        for (Node targetNode : this.nodeSet) {
            if (shortestPathSum == null) {
                shortestPathSum = singleSourceShortestPath.getCost(targetNode);
                continue;
            }
            shortestPathSum = this.centralityAccumulator.addCosts(shortestPathSum, singleSourceShortestPath.getCost(targetNode));
        }
        if (!shortestPathSum.equals(this.zeroValue)) {
            this.setCentralityForNode(node, this.centralityDivider.divideByCost(1.0, shortestPathSum));
        }
    }
}

