/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.batchinsert;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.AutoConfigurator;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.batchinsert.BatchGraphDatabaseImpl;
import org.neo4j.kernel.impl.batchinsert.BatchInserter;
import org.neo4j.kernel.impl.batchinsert.PropertyIndexHolder;
import org.neo4j.kernel.impl.batchinsert.RelationshipTypeHolder;
import org.neo4j.kernel.impl.batchinsert.SimpleRelationship;
import org.neo4j.kernel.impl.index.IndexStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexData;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeData;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeStore;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;

public class BatchInserterImpl
implements BatchInserter {
    private static final long MAX_NODE_ID = IdType.NODE.getMaxValue();
    private static final long MAX_RELATIONSHIP_ID = IdType.RELATIONSHIP.getMaxValue();
    private final NeoStore neoStore;
    private final IndexStore indexStore;
    private final String storeDir;
    private final PropertyIndexHolder indexHolder;
    private final RelationshipTypeHolder typeHolder;
    private final BatchGraphDatabaseImpl graphDbService;
    private final IdGeneratorFactory idGeneratorFactory;
    private final StringLogger msgLog;

    public BatchInserterImpl(String storeDir) {
        this(storeDir, Collections.emptyMap());
    }

    public BatchInserterImpl(String storeDir, Map<String, String> stringParams) {
        this.rejectAutoUpgrade(stringParams);
        this.msgLog = StringLogger.logger(storeDir);
        Map<Object, Object> params = this.getDefaultParams();
        params.put("use_memory_mapped_buffers", "false");
        boolean dump = Boolean.parseBoolean(stringParams.get("dump_configuration"));
        new AutoConfigurator(storeDir, false, dump).configure(params);
        for (Map.Entry<String, String> entry : stringParams.entrySet()) {
            params.put(entry.getKey(), entry.getValue());
        }
        this.storeDir = storeDir;
        this.idGeneratorFactory = CommonFactories.defaultIdGeneratorFactory();
        params.put(IdGeneratorFactory.class, this.idGeneratorFactory);
        FileSystemAbstraction fileSystem = CommonFactories.defaultFileSystemAbstraction();
        params.put(FileSystemAbstraction.class, fileSystem);
        String store = this.fixPath(storeDir, params);
        params.put("neo_store", store);
        if (dump) {
            Config.dumpConfiguration(params);
        }
        this.msgLog.logMessage(Thread.currentThread() + " Starting BatchInserter(" + this + ")");
        this.neoStore = new NeoStore(params);
        if (!this.neoStore.isStoreOk()) {
            throw new IllegalStateException(storeDir + " store is not cleanly shutdown.");
        }
        this.neoStore.makeStoreOk();
        PropertyIndexData[] indexes = this.getPropertyIndexStore().getPropertyIndexes(10000);
        this.indexHolder = new PropertyIndexHolder(indexes);
        RelationshipTypeData[] types = this.getRelationshipTypeStore().getRelationshipTypes();
        this.typeHolder = new RelationshipTypeHolder(types);
        this.graphDbService = new BatchGraphDatabaseImpl(this);
        this.indexStore = new IndexStore(storeDir, fileSystem);
    }

    @Override
    public boolean nodeHasProperty(long node, String propertyName) {
        return this.primitiveHasProperty(this.getNodeRecord(node), propertyName);
    }

    @Override
    public boolean relationshipHasProperty(long relationship, String propertyName) {
        return this.primitiveHasProperty(this.getRelationshipRecord(relationship), propertyName);
    }

    @Override
    public void setNodeProperty(long node, String propertyName, Object propertyValue) {
        NodeRecord nodeRec = this.getNodeRecord(node);
        if (this.setPrimitiveProperty(nodeRec, propertyName, propertyValue)) {
            this.getNodeStore().updateRecord(nodeRec);
        }
    }

    @Override
    public void setRelationshipProperty(long relationship, String propertyName, Object propertyValue) {
        RelationshipRecord relRec = this.getRelationshipRecord(relationship);
        if (this.setPrimitiveProperty(relRec, propertyName, propertyValue)) {
            this.getRelationshipStore().updateRecord(relRec);
        }
    }

    @Override
    public void removeNodeProperty(long node, String propertyName) {
        NodeRecord nodeRec = this.getNodeRecord(node);
        if (this.removePrimitiveProperty(nodeRec, propertyName)) {
            this.getNodeStore().updateRecord(nodeRec);
        }
    }

    @Override
    public void removeRelationshipProperty(long relationship, String propertyName) {
        RelationshipRecord relationshipRec = this.getRelationshipRecord(relationship);
        if (this.removePrimitiveProperty(relationshipRec, propertyName)) {
            this.getRelationshipStore().updateRecord(relationshipRec);
        }
    }

    private boolean removePrimitiveProperty(PrimitiveRecord primitive, String property) {
        PropertyRecord current = null;
        PropertyBlock target = null;
        long nextProp = primitive.getNextProp();
        int propIndex = this.indexHolder.getKeyId(property);
        if (nextProp == (long)Record.NO_NEXT_PROPERTY.intValue() || propIndex == -1) {
            return false;
        }
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            current = this.getPropertyStore().getRecord(nextProp);
            target = current.removePropertyBlock(propIndex);
            if (target != null) {
                if (target.isLight()) {
                    this.getPropertyStore().makeHeavy(target);
                }
                for (DynamicRecord dynRec : target.getValueRecords()) {
                    current.addDeletedRecord(dynRec);
                }
                break;
            }
            nextProp = current.getNextProp();
        }
        if (current.size() > 0) {
            this.getPropertyStore().updateRecord(current);
            return false;
        }
        return this.unlinkPropertyRecord(current, primitive);
    }

    private boolean unlinkPropertyRecord(PropertyRecord propRecord, PrimitiveRecord primitive) {
        assert (propRecord.size() == 0);
        boolean primitiveChanged = false;
        long prevProp = propRecord.getPrevProp();
        long nextProp = propRecord.getNextProp();
        if (primitive.getNextProp() == propRecord.getId()) {
            assert (propRecord.getPrevProp() == (long)Record.NO_PREVIOUS_PROPERTY.intValue()) : propRecord + " for " + primitive;
            primitive.setNextProp(nextProp);
            primitiveChanged = true;
        }
        if (prevProp != (long)Record.NO_PREVIOUS_PROPERTY.intValue()) {
            PropertyRecord prevPropRecord = this.getPropertyStore().getRecord(prevProp);
            assert (prevPropRecord.inUse()) : prevPropRecord + "->" + propRecord + " for " + primitive;
            prevPropRecord.setNextProp(nextProp);
            this.getPropertyStore().updateRecord(prevPropRecord);
        }
        if (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord nextPropRecord = this.getPropertyStore().getRecord(nextProp);
            assert (nextPropRecord.inUse()) : propRecord + "->" + nextPropRecord + " for " + primitive;
            nextPropRecord.setPrevProp(prevProp);
            this.getPropertyStore().updateRecord(nextPropRecord);
        }
        propRecord.setInUse(false);
        propRecord.setPrevProp(Record.NO_PREVIOUS_PROPERTY.intValue());
        propRecord.setNextProp(Record.NO_NEXT_PROPERTY.intValue());
        this.getPropertyStore().updateRecord(propRecord);
        return primitiveChanged;
    }

    private boolean setPrimitiveProperty(PrimitiveRecord primitive, String name, Object value) {
        boolean result = false;
        long nextProp = primitive.getNextProp();
        int index = this.indexHolder.getKeyId(name);
        if (index == -1) {
            index = this.createNewPropertyIndex(name);
        }
        PropertyBlock block = new PropertyBlock();
        this.getPropertyStore().encodeValue(block, index, value);
        int size = block.getSize();
        PropertyRecord current = null;
        PropertyRecord thatFits = null;
        PropertyRecord thatHas = null;
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue() && (thatHas == null || thatFits == null)) {
            current = this.getPropertyStore().getRecord(nextProp);
            if (thatHas == null && current.getPropertyBlock(index) != null) {
                thatHas = current;
                PropertyBlock removed = thatHas.removePropertyBlock(index);
                if (removed.isLight()) {
                    this.getPropertyStore().makeHeavy(removed);
                    for (DynamicRecord dynRec : removed.getValueRecords()) {
                        thatHas.addDeletedRecord(dynRec);
                    }
                }
                this.getPropertyStore().updateRecord(thatHas);
            }
            if (thatFits == null && PropertyType.getPayloadSize() - current.size() >= size) {
                thatFits = current;
            }
            nextProp = current.getNextProp();
        }
        if (thatFits == null) {
            thatFits = new PropertyRecord(this.getPropertyStore().nextId());
            if (primitive.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
                PropertyRecord first = this.getPropertyStore().getRecord(primitive.getNextProp());
                thatFits.setNextProp(first.getId());
                first.setPrevProp(thatFits.getId());
                this.getPropertyStore().updateRecord(first);
                result = true;
            }
            primitive.setNextProp(thatFits.getId());
        }
        thatFits.addPropertyBlock(block);
        this.getPropertyStore().updateRecord(thatFits);
        return result;
    }

    private boolean primitiveHasProperty(PrimitiveRecord record, String propertyName) {
        long nextProp = record.getNextProp();
        int propertyIndex = this.indexHolder.getKeyId(propertyName);
        if (nextProp == (long)Record.NO_NEXT_PROPERTY.intValue() || propertyIndex == -1) {
            return false;
        }
        PropertyRecord current = null;
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            current = this.getPropertyStore().getRecord(nextProp);
            if (current.getPropertyBlock(propertyIndex) != null) {
                return true;
            }
            nextProp = current.getNextProp();
        }
        return false;
    }

    private void rejectAutoUpgrade(Map<String, String> stringParams) {
        if (Boolean.parseBoolean(stringParams.get("allow_store_upgrade"))) {
            throw new IllegalArgumentException("Batch inserter is not allowed to do upgrade of a store, use " + EmbeddedGraphDatabase.class.getSimpleName() + " instead");
        }
    }

    @Override
    public long createNode(Map<String, Object> properties) {
        long nodeId = this.getNodeStore().nextId();
        NodeRecord nodeRecord = new NodeRecord(nodeId);
        nodeRecord.setInUse(true);
        nodeRecord.setCreated();
        nodeRecord.setNextProp(this.createPropertyChain(properties));
        this.getNodeStore().updateRecord(nodeRecord);
        return nodeId;
    }

    @Override
    public void createNode(long id, Map<String, Object> properties) {
        if (id < 0L || id > MAX_NODE_ID) {
            throw new IllegalArgumentException("id=" + id);
        }
        if (id == 0xFFFFFFFFL) {
            throw new IllegalArgumentException("id " + id + " is reserved for internal use");
        }
        long nodeId = id;
        NodeStore nodeStore = this.neoStore.getNodeStore();
        if (this.neoStore.getNodeStore().loadLightNode(nodeId)) {
            throw new IllegalArgumentException("id=" + id + " already in use");
        }
        long highId = nodeStore.getHighId();
        if (highId <= id) {
            nodeStore.setHighId(nodeId + 1L);
        }
        NodeRecord nodeRecord = new NodeRecord(nodeId);
        nodeRecord.setInUse(true);
        nodeRecord.setCreated();
        nodeRecord.setNextProp(this.createPropertyChain(properties));
        this.getNodeStore().updateRecord(nodeRecord);
    }

    @Override
    public long createRelationship(long node1, long node2, RelationshipType type, Map<String, Object> properties) {
        NodeRecord firstNode = this.getNodeRecord(node1);
        NodeRecord secondNode = this.getNodeRecord(node2);
        int typeId = this.typeHolder.getTypeId(type.name());
        if (typeId == -1) {
            typeId = this.createNewRelationshipType(type.name());
        }
        long id = this.getRelationshipStore().nextId();
        RelationshipRecord record = new RelationshipRecord(id, node1, node2, typeId);
        record.setInUse(true);
        record.setCreated();
        this.connectRelationship(firstNode, secondNode, record);
        this.getNodeStore().updateRecord(firstNode);
        this.getNodeStore().updateRecord(secondNode);
        record.setNextProp(this.createPropertyChain(properties));
        this.getRelationshipStore().updateRecord(record);
        return id;
    }

    private void connectRelationship(NodeRecord firstNode, NodeRecord secondNode, RelationshipRecord rel) {
        assert (firstNode.getNextRel() != rel.getId());
        assert (secondNode.getNextRel() != rel.getId());
        rel.setFirstNextRel(firstNode.getNextRel());
        rel.setSecondNextRel(secondNode.getNextRel());
        this.connect(firstNode, rel);
        this.connect(secondNode, rel);
        firstNode.setNextRel(rel.getId());
        secondNode.setNextRel(rel.getId());
    }

    private void connect(NodeRecord node, RelationshipRecord rel) {
        if (node.getNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RelationshipRecord nextRel = this.getRelationshipStore().getRecord(node.getNextRel());
            boolean changed = false;
            if (nextRel.getFirstNode() == node.getId()) {
                nextRel.setFirstPrevRel(rel.getId());
                changed = true;
            }
            if (nextRel.getSecondNode() == node.getId()) {
                nextRel.setSecondPrevRel(rel.getId());
                changed = true;
            }
            if (!changed) {
                throw new InvalidRecordException(node + " dont match " + nextRel);
            }
            this.getRelationshipStore().updateRecord(nextRel);
        }
    }

    @Override
    public void setNodeProperties(long node, Map<String, Object> properties) {
        NodeRecord record = this.getNodeRecord(node);
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            this.deletePropertyChain(record.getNextProp());
            record.setNextProp(Record.NO_NEXT_PROPERTY.intValue());
            this.getNodeStore().updateRecord(record);
        }
        record.setNextProp(this.createPropertyChain(properties));
        this.getNodeStore().updateRecord(record);
    }

    @Override
    public void setRelationshipProperties(long rel, Map<String, Object> properties) {
        RelationshipRecord record = this.getRelationshipRecord(rel);
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            this.deletePropertyChain(record.getNextProp());
            record.setNextProp(Record.NO_NEXT_PROPERTY.intValue());
            this.getRelationshipStore().updateRecord(record);
        }
        record.setNextProp(this.createPropertyChain(properties));
        this.getRelationshipStore().updateRecord(record);
    }

    @Override
    public boolean nodeExists(long nodeId) {
        return this.neoStore.getNodeStore().loadLightNode(nodeId);
    }

    @Override
    public Map<String, Object> getNodeProperties(long nodeId) {
        NodeRecord record = this.getNodeRecord(nodeId);
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return this.getPropertyChain(record.getNextProp());
        }
        return Collections.emptyMap();
    }

    @Override
    public Iterable<Long> getRelationshipIds(long nodeId) {
        NodeRecord nodeRecord = this.getNodeRecord(nodeId);
        long nextRel = nodeRecord.getNextRel();
        ArrayList<Long> ids = new ArrayList<Long>();
        while (nextRel != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RelationshipRecord relRecord = this.getRelationshipRecord(nextRel);
            ids.add(relRecord.getId());
            long firstNode = relRecord.getFirstNode();
            long secondNode = relRecord.getSecondNode();
            if (firstNode == nodeId) {
                nextRel = relRecord.getFirstNextRel();
                continue;
            }
            if (secondNode == nodeId) {
                nextRel = relRecord.getSecondNextRel();
                continue;
            }
            throw new InvalidRecordException("Node[" + nodeId + "] not part of firstNode[" + firstNode + "] or secondNode[" + secondNode + "]");
        }
        return ids;
    }

    @Override
    public Iterable<SimpleRelationship> getRelationships(long nodeId) {
        NodeRecord nodeRecord = this.getNodeRecord(nodeId);
        long nextRel = nodeRecord.getNextRel();
        ArrayList<SimpleRelationship> rels = new ArrayList<SimpleRelationship>();
        while (nextRel != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RelationshipRecord relRecord = this.getRelationshipRecord(nextRel);
            RelationshipTypeImpl type = new RelationshipTypeImpl(this.typeHolder.getName(relRecord.getType()));
            rels.add(new SimpleRelationship(relRecord.getId(), relRecord.getFirstNode(), relRecord.getSecondNode(), type));
            long firstNode = relRecord.getFirstNode();
            long secondNode = relRecord.getSecondNode();
            if (firstNode == nodeId) {
                nextRel = relRecord.getFirstNextRel();
                continue;
            }
            if (secondNode == nodeId) {
                nextRel = relRecord.getSecondNextRel();
                continue;
            }
            throw new InvalidRecordException("Node[" + nodeId + "] not part of firstNode[" + firstNode + "] or secondNode[" + secondNode + "]");
        }
        return rels;
    }

    @Override
    public SimpleRelationship getRelationshipById(long relId) {
        RelationshipRecord record = this.getRelationshipRecord(relId);
        RelationshipTypeImpl type = new RelationshipTypeImpl(this.typeHolder.getName(record.getType()));
        return new SimpleRelationship(record.getId(), record.getFirstNode(), record.getSecondNode(), type);
    }

    @Override
    public Map<String, Object> getRelationshipProperties(long relId) {
        RelationshipRecord record = this.getRelationshipRecord(relId);
        if (record.getNextProp() != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return this.getPropertyChain(record.getNextProp());
        }
        return Collections.emptyMap();
    }

    @Override
    public void shutdown() {
        this.graphDbService.clearCaches();
        this.neoStore.close();
        this.msgLog.logMessage(Thread.currentThread() + " Clean shutdown on BatchInserter(" + this + ")", true);
        this.msgLog.close();
    }

    private Map<Object, Object> getDefaultParams() {
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        params.put("neostore.nodestore.db.mapped_memory", "20M");
        params.put("neostore.propertystore.db.mapped_memory", "90M");
        params.put("neostore.propertystore.db.index.mapped_memory", "1M");
        params.put("neostore.propertystore.db.index.keys.mapped_memory", "1M");
        params.put("neostore.propertystore.db.strings.mapped_memory", "130M");
        params.put("neostore.propertystore.db.arrays.mapped_memory", "130M");
        params.put("neostore.relationshipstore.db.mapped_memory", "50M");
        return params;
    }

    public String toString() {
        return "EmbeddedBatchInserter[" + this.storeDir + "]";
    }

    private long createPropertyChain(Map<String, Object> properties) {
        if (properties == null || properties.isEmpty()) {
            return Record.NO_NEXT_PROPERTY.intValue();
        }
        PropertyStore propStore = this.getPropertyStore();
        ArrayList<PropertyRecord> propRecords = new ArrayList<PropertyRecord>();
        PropertyRecord currentRecord = new PropertyRecord(propStore.nextId());
        currentRecord.setInUse(true);
        currentRecord.setCreated();
        propRecords.add(currentRecord);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            int keyId = this.indexHolder.getKeyId(entry.getKey());
            if (keyId == -1) {
                keyId = this.createNewPropertyIndex(entry.getKey());
            }
            PropertyBlock block = new PropertyBlock();
            propStore.encodeValue(block, keyId, entry.getValue());
            if (currentRecord.size() + block.getSize() > PropertyType.getPayloadSize()) {
                PropertyRecord prevRecord = currentRecord;
                long propertyId = propStore.nextId();
                currentRecord = new PropertyRecord(propertyId);
                currentRecord.setInUse(true);
                currentRecord.setCreated();
                prevRecord.setNextProp(propertyId);
                currentRecord.setPrevProp(prevRecord.getId());
                propRecords.add(currentRecord);
            }
            currentRecord.addPropertyBlock(block);
        }
        for (int i = propRecords.size() - 1; i >= 0; --i) {
            propStore.updateRecord((PropertyRecord)propRecords.get(i));
        }
        return ((PropertyRecord)propRecords.get(0)).getId();
    }

    private void deletePropertyChain(long nextProp) {
        PropertyStore propStore = this.getPropertyStore();
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = propStore.getRecord(nextProp);
            for (PropertyBlock propBlock : propRecord.getPropertyBlocks()) {
                if (propBlock.isLight()) {
                    propStore.makeHeavy(propBlock);
                }
                for (DynamicRecord rec : propBlock.getValueRecords()) {
                    rec.setInUse(false);
                    propRecord.addDeletedRecord(rec);
                }
            }
            propRecord.setInUse(false);
            nextProp = propRecord.getNextProp();
            propStore.updateRecord(propRecord);
        }
    }

    private Map<String, Object> getPropertyChain(long nextProp) {
        PropertyStore propStore = this.getPropertyStore();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = propStore.getRecord(nextProp);
            for (PropertyBlock propBlock : propRecord.getPropertyBlocks()) {
                String key = this.indexHolder.getStringKey(propBlock.getKeyIndexId());
                PropertyData propertyData = propBlock.newPropertyData(propRecord);
                Object value = propertyData.getValue() != null ? propertyData.getValue() : propBlock.getType().getValue(propBlock, this.getPropertyStore());
                properties.put(key, value);
            }
            nextProp = propRecord.getNextProp();
        }
        return properties;
    }

    private int createNewPropertyIndex(String stringKey) {
        PropertyIndexStore idxStore = this.getPropertyIndexStore();
        int keyId = (int)idxStore.nextId();
        PropertyIndexRecord record = new PropertyIndexRecord(keyId);
        record.setInUse(true);
        record.setCreated();
        int keyBlockId = idxStore.nextKeyBlockId();
        record.setKeyBlockId(keyBlockId);
        Collection<DynamicRecord> keyRecords = idxStore.allocateKeyRecords(keyBlockId, PropertyStore.encodeString(stringKey));
        for (DynamicRecord keyRecord : keyRecords) {
            record.addKeyRecord(keyRecord);
        }
        idxStore.updateRecord(record);
        this.indexHolder.addPropertyIndex(stringKey, keyId);
        return keyId;
    }

    private int createNewRelationshipType(String name) {
        RelationshipTypeStore typeStore = this.getRelationshipTypeStore();
        int id = (int)typeStore.nextId();
        RelationshipTypeRecord record = new RelationshipTypeRecord(id);
        record.setInUse(true);
        record.setCreated();
        int typeBlockId = (int)typeStore.nextBlockId();
        record.setTypeBlock(typeBlockId);
        Collection<DynamicRecord> typeRecords = typeStore.allocateTypeNameRecords(typeBlockId, PropertyStore.encodeString(name));
        for (DynamicRecord typeRecord : typeRecords) {
            record.addTypeRecord(typeRecord);
        }
        typeStore.updateRecord(record);
        this.typeHolder.addRelationshipType(name, id);
        return id;
    }

    private NodeStore getNodeStore() {
        return this.neoStore.getNodeStore();
    }

    private PropertyStore getPropertyStore() {
        return this.neoStore.getPropertyStore();
    }

    private PropertyIndexStore getPropertyIndexStore() {
        return this.getPropertyStore().getIndexStore();
    }

    private RelationshipStore getRelationshipStore() {
        return this.neoStore.getRelationshipStore();
    }

    private RelationshipTypeStore getRelationshipTypeStore() {
        return this.neoStore.getRelationshipTypeStore();
    }

    private NodeRecord getNodeRecord(long id) {
        if (id < 0L || id >= this.getNodeStore().getHighId()) {
            throw new NotFoundException("id=" + id);
        }
        return this.getNodeStore().getRecord(id);
    }

    private RelationshipRecord getRelationshipRecord(long id) {
        if (id < 0L || id >= this.getRelationshipStore().getHighId()) {
            throw new NotFoundException("id=" + id);
        }
        return this.getRelationshipStore().getRecord(id);
    }

    private String fixPath(String dir, Map<?, ?> config) {
        File directories = new File(dir);
        if (!directories.exists() && !directories.mkdirs()) {
            throw new UnderlyingStorageException("Unable to create directory path[" + this.storeDir + "] for Neo4j kernel store.");
        }
        dir = FileUtils.fixSeparatorsInPath(dir);
        String fileSeparator = System.getProperty("file.separator");
        String store = dir + fileSeparator + "neostore";
        if (!new File(store).exists()) {
            NeoStore.createStore(store, config);
        }
        return store;
    }

    @Override
    public String getStore() {
        return this.storeDir;
    }

    public static Map<String, String> loadProperties(String file) {
        return EmbeddedGraphDatabase.loadConfigurations(file);
    }

    @Override
    public long getReferenceNode() {
        if (this.nodeExists(0L)) {
            return 0L;
        }
        return -1L;
    }

    @Override
    public GraphDatabaseService getGraphDbService() {
        return this.graphDbService;
    }

    public IndexStore getIndexStore() {
        return this.indexStore;
    }

    public IdGeneratorFactory getIdGeneratorFactory() {
        return this.idGeneratorFactory;
    }

    private static class RelationshipTypeImpl
    implements RelationshipType {
        private final String name;

        RelationshipTypeImpl(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }
    }
}

