/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ext.udc.impl;

import java.io.InputStream;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.neo4j.ext.udc.UdcProperties;
import org.neo4j.ext.udc.impl.UdcTimerTask;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.KernelExtension;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;

public class UdcExtensionImpl
extends KernelExtension<UdcTimerTask>
implements UdcProperties {
    static final String KEY = "kernel udc";
    public static final String UDC_SOURCE_DISTRIBUTION_KEY = "neo4j.ext.udc.host";
    private static final int DEFAULT_INTERVAL = 86400000;
    private static final int DEFAULT_DELAY = 600000;
    private static final String DEFAULT_HOST = "udc.neo4j.org";
    private static Timer timer = new Timer("Neo4j UDC Timer", true);

    public UdcExtensionImpl() {
        super(KEY);
    }

    protected UdcTimerTask load(KernelData kernel) {
        MyConfig configuration = new MyConfig(kernel.getConfig(), this.loadSystemProperties());
        try {
            if (configuration.getBool("neo4j.ext.udc.disable", "false")) {
                return null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int firstDelay = 600000;
        int interval = 86400000;
        String hostAddress = DEFAULT_HOST;
        String source = null;
        try {
            firstDelay = configuration.getInt("neo4j.ext.udc.first_delay", Integer.toString(firstDelay));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            interval = configuration.getInt("neo4j.ext.udc.interval", Integer.toString(interval));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            hostAddress = configuration.getString(UDC_SOURCE_DISTRIBUTION_KEY, hostAddress);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            source = configuration.getString("neo4j.ext.udc.source", source);
        }
        catch (Exception e) {
            // empty catch block
        }
        NeoStoreXaDataSource ds = (NeoStoreXaDataSource)kernel.getConfig().getTxModule().getXaDataSourceManager().getXaDataSource("nioneodb");
        boolean crashPing = ds.getXaContainer().getLogicalLog().wasNonClean();
        String storeId = Long.toHexString(ds.getRandomIdentifier());
        String version = kernel.version().getRevision();
        if (version.equals("")) {
            version = kernel.version().getVersion();
        }
        UdcTimerTask task = new UdcTimerTask(hostAddress, version, storeId, source, crashPing);
        timer.scheduleAtFixedRate((TimerTask)task, firstDelay, (long)interval);
        return task;
    }

    protected void unload(UdcTimerTask task) {
        task.cancel();
    }

    private Properties loadSystemProperties() {
        Properties sysProps = System.getProperties();
        try {
            InputStream resource = this.getClass().getResourceAsStream("/org/neo4j/ext/udc/udc.properties");
            if (resource != null) {
                sysProps.load(resource);
            }
        }
        catch (Exception e) {
            System.err.println("failed to load udc.properties, because: " + e);
        }
        return sysProps;
    }

    private class MyConfig {
        private final Config config;
        private final Properties props;

        private MyConfig(Config config, Properties props) {
            this.config = config;
            this.props = props;
        }

        private String getString(String key, String defaultValue) {
            String result = (String)this.config.getParams().get(key);
            if (result == null) {
                result = this.props.getProperty(key, defaultValue);
            }
            return result;
        }

        private int getInt(String key, String defaultValue) {
            String result = this.getString(key, defaultValue);
            return Integer.parseInt(result);
        }

        private boolean getBool(String key, String defaultValue) {
            String result = this.getString(key, defaultValue);
            return Boolean.parseBoolean(result);
        }
    }
}

