/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.search.IndexSearcher;
import org.neo4j.index.impl.lucene.IndexIdentifier;

class IndexSearcherRef {
    private final IndexIdentifier identifier;
    private final IndexSearcher searcher;
    private final AtomicInteger refCount = new AtomicInteger(0);
    private volatile boolean isClosed;
    private volatile boolean detached;

    public IndexSearcherRef(IndexIdentifier identifier, IndexSearcher searcher) {
        this.identifier = identifier;
        this.searcher = searcher;
    }

    public IndexSearcher getSearcher() {
        return this.searcher;
    }

    public IndexIdentifier getIdentifier() {
        return this.identifier;
    }

    void incRef() {
        this.refCount.incrementAndGet();
    }

    public void dispose() throws IOException {
        if (!this.isClosed) {
            this.searcher.close();
            this.searcher.getIndexReader().close();
            this.isClosed = true;
        }
    }

    public void detachOrClose() throws IOException {
        if (this.refCount.get() == 0) {
            this.dispose();
        } else {
            this.detached = true;
        }
    }

    public boolean close() throws IOException {
        if (this.isClosed || this.refCount.get() == 0) {
            return true;
        }
        boolean reallyClosed = false;
        if (this.refCount.decrementAndGet() <= 0 && this.detached) {
            this.dispose();
            reallyClosed = true;
        }
        return reallyClosed;
    }

    boolean closeStrict() {
        try {
            return this.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    boolean isClosed() {
        return this.isClosed;
    }
}

