/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelationshipImpl;

class LowRelationshipImpl
extends RelationshipImpl {
    private final long idAndMore;
    private final int startNodeId;
    private final int endNodeId;

    LowRelationshipImpl(long id, long startNodeId, long endNodeId, int typeId, boolean newRel) {
        super(startNodeId, endNodeId, newRel);
        this.startNodeId = (int)startNodeId;
        this.endNodeId = (int)endNodeId;
        this.idAndMore = (long)typeId << 48 | (startNodeId & 0xF00000000L) << 12 | (endNodeId & 0xF00000000L) << 8 | id;
    }

    @Override
    public long getId() {
        return this.idAndMore & 0xFFFFFFFFFFL;
    }

    @Override
    protected long getFirstProp() {
        throw new UnsupportedOperationException();
    }

    @Override
    long getStartNodeId() {
        return (long)this.startNodeId & 0xFFFFFFFFL | (this.idAndMore & 0xF00000000000L) >> 12;
    }

    @Override
    long getEndNodeId() {
        return (long)this.endNodeId & 0xFFFFFFFFL | (this.idAndMore & 0xF0000000000L) >> 8;
    }

    private int getTypeId() {
        return (int)((this.idAndMore & 0xFFFF000000000000L) >> 48);
    }

    @Override
    public RelationshipType getType(NodeManager nodeManager) {
        return nodeManager.getRelationshipTypeById(this.getTypeId());
    }

    @Override
    public String toString() {
        return "RelationshipImpl #" + this.getId() + " of type " + this.getTypeId() + " between Node[" + this.getStartNodeId() + "] and Node[" + this.getEndNodeId() + "]";
    }
}

