/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.Map;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;

public class DynamicStringStore
extends AbstractDynamicStore {
    static final String VERSION = "StringPropertyStore v0.A.0";
    public static final String TYPE_DESCRIPTOR = "StringPropertyStore";

    public DynamicStringStore(String fileName, Map<?, ?> config, IdType idType) {
        super(fileName, config, idType);
    }

    @Override
    public void accept(RecordStore.Processor processor, DynamicRecord record) {
        processor.processString(this, record);
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    public static void createStore(String fileName, int blockSize, IdGeneratorFactory idGeneratorFactory, FileSystemAbstraction fileSystem, IdType idType) {
        DynamicStringStore.createEmptyStore(fileName, blockSize, VERSION, idGeneratorFactory, fileSystem, idType);
    }

    @Override
    public void setHighId(long highId) {
        super.setHighId(highId);
    }

    @Override
    public long nextBlockId() {
        return super.nextBlockId();
    }
}

