/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.pipes;

import org.neo4j.cypher.commands.AggregationItem;
import org.neo4j.cypher.commands.ReturnItem;
import org.neo4j.cypher.internal.pipes.OrderedAggregator;
import org.neo4j.cypher.internal.pipes.Pipe;
import org.neo4j.cypher.internal.pipes.PipeWithSource;
import org.neo4j.cypher.symbols.Identifier;
import org.neo4j.cypher.symbols.SymbolTable;
import org.neo4j.helpers.ThisShouldNotHappenError;
import scala.Function1;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0001\u001b\t1rJ\u001d3fe\u0016$\u0017iZ4sK\u001e\fG/[8o!&\u0004XM\u0003\u0002\u0004\t\u0005)\u0001/\u001b9fg*\u0011QAB\u0001\tS:$XM\u001d8bY*\u0011q\u0001C\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005%Q\u0011!\u00028f_RR'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001q!\u0003\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\tq\u0001+\u001b9f/&$\bnU8ve\u000e,\u0007CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"aC*dC2\fwJ\u00196fGRD\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0007g>,(oY3\u0011\u0005=Y\u0012B\u0001\u000f\u0003\u0005\u0011\u0001\u0016\u000e]3\t\u0011y\u0001!Q1A\u0005\u0002}\t1B]3ukJt\u0017\n^3ngV\t\u0001\u0005E\u0002\"I\u0019j\u0011A\t\u0006\u0003GQ\t!bY8mY\u0016\u001cG/[8o\u0013\t)#EA\u0002TKF\u0004\"a\n\u0016\u000e\u0003!R!!\u000b\u0004\u0002\u0011\r|W.\\1oINL!a\u000b\u0015\u0003\u0015I+G/\u001e:o\u0013R,W\u000e\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003!\u00031\u0011X\r^;s]&#X-\\:!\u0011!y\u0003A!A!\u0002\u0013\u0001\u0014\u0001D1hOJ,w-\u0019;j_:\u001c\bcA\u0011%cA\u0011qEM\u0005\u0003g!\u0012q\"Q4he\u0016<\u0017\r^5p]&#X-\u001c\u0005\u0006k\u0001!\tAN\u0001\u0007y%t\u0017\u000e\u001e \u0015\t]B\u0014H\u000f\t\u0003\u001f\u0001AQ!\u0007\u001bA\u0002iAQA\b\u001bA\u0002\u0001BQa\f\u001bA\u0002ABq\u0001\u0010\u0001C\u0002\u0013\u0005Q(A\u0004ts6\u0014w\u000e\\:\u0016\u0003y\u0002\"aP!\u000e\u0003\u0001S!\u0001\u0010\u0004\n\u0005\t\u0003%aC*z[\n|G\u000eV1cY\u0016Da\u0001\u0012\u0001!\u0002\u0013q\u0014\u0001C:z[\n|Gn\u001d\u0011\t\u000b\u0019\u0003A\u0011A$\u0002\u0019\u0011,\u0007/\u001a8eK:\u001c\u0017.Z:\u0016\u0003!\u00032!\t\u0013J!\ty$*\u0003\u0002L\u0001\nQ\u0011\nZ3oi&4\u0017.\u001a:\t\u000b5\u0003A\u0011\u0001(\u0002\u001b\r\u0014X-\u0019;f'fl'm\u001c7t)\u0005q\u0004\"\u0002)\u0001\t\u0003\t\u0016!D2sK\u0006$XMU3tk2$8/\u0006\u0002SgR\u00111+\u001d\t\u0004)r{fBA+[\u001d\t1\u0016,D\u0001X\u0015\tAF\"\u0001\u0004=e>|GOP\u0005\u0002+%\u00111\fF\u0001\ba\u0006\u001c7.Y4f\u0013\tifLA\u0006Ue\u00064XM]:bE2,'BA.\u0015!\u0011\u00017M\u001a8\u000f\u0005M\t\u0017B\u00012\u0015\u0003\u0019\u0001&/\u001a3fM&\u0011A-\u001a\u0002\u0004\u001b\u0006\u0004(B\u00012\u0015!\t9G.D\u0001i\u0015\tI'.\u0001\u0003mC:<'\"A6\u0002\t)\fg/Y\u0005\u0003[\"\u0014aa\u0015;sS:<\u0007CA\np\u0013\t\u0001HCA\u0002B]fDQA](A\u0002}\u000ba\u0001]1sC6\u001cH!\u0002;P\u0005\u0004)(!A+\u0012\u0005Yt\u0007CA\nx\u0013\tAHCA\u0004O_RD\u0017N\\4\t\u000bi\u0004A\u0011I>\u0002\u001b\u0015DXmY;uS>t\u0007\u000b\\1o)\u00051\u0007")
public class OrderedAggregationPipe
extends PipeWithSource
implements ScalaObject {
    private final Pipe source;
    private final Seq<ReturnItem> returnItems;
    private final Seq<AggregationItem> aggregations;
    private final SymbolTable symbols;

    public Seq<ReturnItem> returnItems() {
        return this.returnItems;
    }

    @Override
    public SymbolTable symbols() {
        return this.symbols;
    }

    @Override
    public Seq<Identifier> dependencies() {
        return (Seq)((TraversableLike)this.returnItems().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<Identifier> apply(ReturnItem returnItem2) {
                return returnItem2.dependencies();
            }
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.aggregations.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<Identifier> apply(AggregationItem aggregationItem) {
                return aggregationItem.dependencies();
            }
        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    public SymbolTable createSymbols() {
        SymbolTable keySymbols = this.source.symbols().filter((Seq<String>)((Seq)this.returnItems().map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(ReturnItem returnItem2) {
                return returnItem2.columnName();
            }
        }, Seq$.MODULE$.canBuildFrom())));
        Seq aggregatedColumns = (Seq)this.aggregations.map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Identifier apply(AggregationItem aggregationItem) {
                return aggregationItem.concreteReturnItem().identifier();
            }
        }, Seq$.MODULE$.canBuildFrom());
        return keySymbols.add((Seq<Identifier>)aggregatedColumns);
    }

    @Override
    public <U> Traversable<Map<String, Object>> createResults(Map<String, Object> params) {
        return new OrderedAggregator(this.source.createResults(params), this.returnItems(), this.aggregations);
    }

    @Override
    public String executionPlan() {
        return new StringBuilder().append((Object)this.source.executionPlan()).append((Object)"\r\n").append((Object)"EagerAggregation( keys: [").append((Object)((TraversableOnce)this.returnItems().map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(ReturnItem returnItem2) {
                return returnItem2.columnName();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ")).append((Object)"], aggregates: [").append((Object)this.aggregations.mkString(", ")).append((Object)"])").toString();
    }

    public OrderedAggregationPipe(Pipe source, Seq<ReturnItem> returnItems, Seq<AggregationItem> aggregations) {
        this.source = source;
        this.returnItems = returnItems;
        this.aggregations = aggregations;
        super(source);
        if (returnItems.isEmpty()) {
            throw new ThisShouldNotHappenError("Andres Taylor", "The ordered aggregation pipe should never be used without aggregation keys");
        }
        this.symbols = this.createSymbols();
    }
}

