/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphmatching;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphmatching.AbstractPatternObject;
import org.neo4j.graphmatching.PatternNode;

public class PatternRelationship
extends AbstractPatternObject<Relationship> {
    private final RelationshipType type;
    private final boolean directed;
    private final boolean optional;
    private final boolean anyType;
    private final PatternNode firstNode;
    private final PatternNode secondNode;
    private boolean isMarked = false;

    PatternRelationship(PatternNode firstNode, PatternNode secondNode, boolean optional, boolean directed) {
        this.directed = directed;
        this.anyType = true;
        this.firstNode = firstNode;
        this.secondNode = secondNode;
        this.optional = optional;
        this.type = null;
    }

    PatternRelationship(RelationshipType type, PatternNode firstNode, PatternNode secondNode, boolean optional, boolean directed) {
        this.directed = directed;
        this.anyType = false;
        this.type = type;
        this.firstNode = firstNode;
        this.secondNode = secondNode;
        this.optional = optional;
    }

    boolean anyRelType() {
        return this.anyType;
    }

    public PatternNode getOtherNode(PatternNode node) {
        if (node == this.firstNode) {
            return this.secondNode;
        }
        if (node == this.secondNode) {
            return this.firstNode;
        }
        throw new RuntimeException("Node[" + node + "] not in this relationship");
    }

    public PatternNode getFirstNode() {
        return this.firstNode;
    }

    public PatternNode getSecondNode() {
        return this.secondNode;
    }

    public boolean isOptional() {
        return this.optional;
    }

    void mark() {
        this.isMarked = true;
    }

    void unMark() {
        this.isMarked = false;
    }

    boolean isMarked() {
        return this.isMarked;
    }

    public RelationshipType getType() {
        return this.type;
    }

    public Direction getDirectionFrom(PatternNode fromNode) {
        if (!this.directed) {
            return Direction.BOTH;
        }
        if (fromNode.equals(this.firstNode)) {
            return Direction.OUTGOING;
        }
        if (fromNode.equals(this.secondNode)) {
            return Direction.INCOMING;
        }
        throw new RuntimeException(fromNode + " not in " + this);
    }

    public String toString() {
        return this.type + ":" + this.optional;
    }
}

