/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphmatching;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphmatching.AbstractPatternObject;
import org.neo4j.graphmatching.OptionalPatternFinder;
import org.neo4j.graphmatching.PatternElement;
import org.neo4j.graphmatching.PatternMatch;
import org.neo4j.graphmatching.PatternMatcher;
import org.neo4j.graphmatching.PatternNode;
import org.neo4j.graphmatching.PatternPosition;
import org.neo4j.graphmatching.PatternRelationship;
import org.neo4j.graphmatching.ValueMatcher;

@Deprecated
class PatternFinder
implements Iterable<PatternMatch>,
Iterator<PatternMatch> {
    private Set<Relationship> visitedRels = new HashSet<Relationship>();
    private PatternPosition currentPosition;
    private OptionalPatternFinder optionalFinder;
    private PatternNode startPatternNode;
    private Node startNode;
    private Collection<PatternNode> optionalNodes;
    private boolean optional;
    private final PatternMatcher matcher;
    private Stack<CallPosition> callStack = new Stack();
    private Stack<PatternPosition> uncompletedPositions = new Stack();
    private Stack<PatternElement> foundElements = new Stack();
    private PatternMatch match = null;
    private PatternMatch optionalMatch = null;

    PatternFinder(PatternMatcher matcher, PatternNode start, Node startNode) {
        this(matcher, start, startNode, false);
    }

    PatternFinder(PatternMatcher matcher, PatternNode start, Node startNode, boolean optional) {
        this.matcher = matcher;
        this.startPatternNode = start;
        this.startNode = startNode;
        this.currentPosition = new PatternPosition(startNode, start, optional);
        this.optional = optional;
    }

    PatternFinder(PatternMatcher matcher, PatternNode start, Node startNode, boolean optional, Collection<PatternNode> optionalNodes) {
        this(matcher, start, startNode, optional);
        this.optionalNodes = optionalNodes;
    }

    PatternNode getStartPatternNode() {
        return this.startPatternNode;
    }

    Node getStartNode() {
        return this.startNode;
    }

    private PatternMatch findNextMatch() {
        if (this.callStack.isEmpty() && this.currentPosition != null) {
            if (this.traverse(this.currentPosition, true)) {
                this.currentPosition = null;
                HashMap<PatternNode, PatternElement> filteredElements = new HashMap<PatternNode, PatternElement>();
                HashMap<PatternRelationship, Relationship> relElements = new HashMap<PatternRelationship, Relationship>();
                for (PatternElement element : this.foundElements) {
                    filteredElements.put(element.getPatternNode(), element);
                    relElements.put(element.getFromPatternRelationship(), element.getFromRelationship());
                }
                PatternMatch patternMatch = new PatternMatch(filteredElements, relElements);
                this.foundElements.pop();
                return patternMatch;
            }
            this.currentPosition = null;
        } else if (!this.callStack.isEmpty()) {
            boolean matchFound = false;
            do {
                CallPosition callStackInformation = this.callStack.peek();
                matchFound = this.traverse(callStackInformation);
            } while (!this.callStack.isEmpty() && !matchFound);
            if (matchFound) {
                HashMap<PatternNode, PatternElement> filteredElements = new HashMap<PatternNode, PatternElement>();
                HashMap<PatternRelationship, Relationship> relElements = new HashMap<PatternRelationship, Relationship>();
                for (PatternElement element : this.foundElements) {
                    filteredElements.put(element.getPatternNode(), element);
                    relElements.put(element.getFromPatternRelationship(), element.getFromRelationship());
                }
                PatternMatch patternMatch = new PatternMatch(filteredElements, relElements);
                this.foundElements.pop();
                return patternMatch;
            }
        }
        return null;
    }

    private boolean traverse(CallPosition callPos) {
        PatternPosition currentPos = callPos.getPatternPosition();
        PatternRelationship pRel = callPos.getPatternRelationship();
        pRel.mark();
        this.visitedRels.remove(callPos.getLastVisitedRelationship());
        Node currentNode = currentPos.getCurrentNode();
        Iterator<Relationship> relItr = callPos.getRelationshipIterator();
        while (relItr.hasNext()) {
            Relationship rel = relItr.next();
            if (this.visitedRels.contains(rel) || !this.checkProperties(pRel, (PropertyContainer)rel)) continue;
            Node otherNode = rel.getOtherNode(currentNode);
            PatternNode otherPosition = pRel.getOtherNode(currentPos.getPatternNode());
            pRel.mark();
            this.visitedRels.add(rel);
            if (this.traverse(new PatternPosition(otherNode, otherPosition, pRel, rel, this.optional), true)) {
                callPos.setLastVisitedRelationship(rel);
                return true;
            }
            this.visitedRels.remove(rel);
            pRel.unMark();
        }
        pRel.unMark();
        if (callPos.shouldPopUncompleted()) {
            this.uncompletedPositions.pop();
        }
        this.callStack.pop();
        this.foundElements.pop();
        return false;
    }

    private boolean traverse(PatternPosition currentPos, boolean pushElement) {
        Node currentNode;
        PatternNode pNode = currentPos.getPatternNode();
        if (!this.checkProperties(pNode, (PropertyContainer)(currentNode = currentPos.getCurrentNode()))) {
            return false;
        }
        if (pushElement) {
            this.foundElements.push(new PatternElement(pNode, currentPos.fromPatternRel(), currentNode, currentPos.fromRelationship()));
        }
        if (currentPos.hasNext()) {
            boolean popUncompleted = false;
            PatternRelationship pRel = currentPos.next();
            if (currentPos.hasNext()) {
                this.uncompletedPositions.push(currentPos);
                popUncompleted = true;
            }
            assert (!pRel.isMarked());
            Iterator<Relationship> relItr = this.getRelationshipIterator(currentPos.getPatternNode(), currentNode, pRel);
            pRel.mark();
            while (relItr.hasNext()) {
                Relationship rel = relItr.next();
                if (this.visitedRels.contains(rel) || !this.checkProperties(pRel, (PropertyContainer)rel)) continue;
                Node otherNode = rel.getOtherNode(currentNode);
                PatternNode otherPosition = pRel.getOtherNode(currentPos.getPatternNode());
                this.visitedRels.add(rel);
                CallPosition callPos = new CallPosition(currentPos, rel, relItr, pRel, popUncompleted);
                this.callStack.push(callPos);
                if (this.traverse(new PatternPosition(otherNode, otherPosition, pRel, rel, this.optional), true)) {
                    return true;
                }
                this.callStack.pop();
                this.visitedRels.remove(rel);
            }
            pRel.unMark();
            if (popUncompleted) {
                this.uncompletedPositions.pop();
            }
            this.foundElements.pop();
            return false;
        }
        boolean matchFound = true;
        if (!this.uncompletedPositions.isEmpty()) {
            PatternPosition digPos = this.uncompletedPositions.pop();
            digPos.reset();
            matchFound = this.traverse(digPos, false);
            this.uncompletedPositions.push(digPos);
            return matchFound;
        }
        return true;
    }

    private Iterator<Relationship> getRelationshipIterator(PatternNode fromNode, Node currentNode, PatternRelationship pRel) {
        Iterator<Object> relItr = null;
        relItr = pRel.anyRelType() ? currentNode.getRelationships(pRel.getDirectionFrom(fromNode)).iterator() : currentNode.getRelationships(pRel.getType(), pRel.getDirectionFrom(fromNode)).iterator();
        return relItr;
    }

    private boolean checkProperties(AbstractPatternObject<? extends PropertyContainer> patternObject, PropertyContainer object) {
        PropertyContainer associatedObject = patternObject.getAssociation();
        if (associatedObject != null && !object.equals(associatedObject)) {
            return false;
        }
        for (Map.Entry<String, Collection<ValueMatcher>> matchers : patternObject.getPropertyConstraints()) {
            String key = matchers.getKey();
            Object propertyValue = object.getProperty(key, null);
            for (ValueMatcher matcher : matchers.getValue()) {
                if (matcher.matches(propertyValue)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Iterator<PatternMatch> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.match == null) {
            this.match = this.findNextMatch();
            this.optionalFinder = null;
        } else if (this.optionalNodes != null) {
            if (this.optionalFinder == null) {
                this.optionalFinder = new OptionalPatternFinder(this.matcher, this.match, this.optionalNodes);
            }
            if (this.optionalMatch == null) {
                this.optionalMatch = this.optionalFinder.findNextOptionalPatterns();
            }
            if (this.optionalMatch == null && this.optionalFinder.anyMatchFound()) {
                this.match = null;
                return this.hasNext();
            }
        }
        return this.match != null;
    }

    @Override
    public PatternMatch next() {
        if (this.match == null) {
            this.match = this.findNextMatch();
            this.optionalFinder = null;
        }
        PatternMatch matchToReturn = this.match;
        PatternMatch optionalMatchToReturn = null;
        if (this.match != null && this.optionalNodes != null) {
            if (this.optionalFinder == null) {
                this.optionalFinder = new OptionalPatternFinder(this.matcher, this.match, this.optionalNodes);
            }
            if (this.optionalMatch == null) {
                this.optionalMatch = this.optionalFinder.findNextOptionalPatterns();
            }
            optionalMatchToReturn = this.optionalMatch;
            this.optionalMatch = null;
            if (optionalMatchToReturn == null) {
                this.match = null;
                if (this.optionalFinder.anyMatchFound()) {
                    return this.next();
                }
            }
        } else {
            this.match = null;
        }
        if (matchToReturn == null) {
            throw new NoSuchElementException();
        }
        return optionalMatchToReturn != null ? PatternMatch.merge(matchToReturn, optionalMatchToReturn) : matchToReturn;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class CallPosition {
        private PatternPosition patternPosition;
        private Iterator<Relationship> relItr;
        private Relationship lastRel;
        private PatternRelationship currentPRel;
        private boolean popUncompleted;

        CallPosition(PatternPosition patternPosition, Relationship lastRel, Iterator<Relationship> relItr, PatternRelationship currentPRel, boolean popUncompleted) {
            this.patternPosition = patternPosition;
            this.relItr = relItr;
            this.lastRel = lastRel;
            this.currentPRel = currentPRel;
            this.popUncompleted = popUncompleted;
        }

        public void setLastVisitedRelationship(Relationship rel) {
            this.lastRel = rel;
        }

        public Relationship getLastVisitedRelationship() {
            return this.lastRel;
        }

        public boolean shouldPopUncompleted() {
            return this.popUncompleted;
        }

        public PatternPosition getPatternPosition() {
            return this.patternPosition;
        }

        public PatternRelationship getPatternRelationship() {
            return this.currentPRel;
        }

        public Iterator<Relationship> getRelationshipIterator() {
            return this.relItr;
        }
    }
}

