/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.io.PrintStream;

public interface ProgressIndicator {
    public void update(boolean var1, long var2);

    public void done(long var1);

    public static abstract class MultiProgress
    extends SimpleProgress {
        private long base = 0L;

        public MultiProgress(long total) {
            super(total);
        }

        public static MultiProgress textual(final PrintStream out, long total) {
            return new MultiProgress(total){

                @Override
                protected void progress(int permille) {
                    1.textualProgress(out, permille);
                }
            };
        }

        @Override
        long currentProgress(boolean incremental, long value) {
            return this.base + super.currentProgress(incremental, value);
        }

        @Override
        public void done(long totalSegmentProgress) {
            this.update(false, totalSegmentProgress);
            this.base += totalSegmentProgress;
            this.currentProgress(false, 0L);
        }

        @Override
        public void done() {
            super.done();
        }
    }

    public static abstract class SimpleProgress
    implements ProgressIndicator {
        private final long total;
        private int lastPermille = 0;
        private long currentProgress = 0L;

        public SimpleProgress(long total) {
            this.total = total;
        }

        public static SimpleProgress textual(final PrintStream out, long total) {
            return new SimpleProgress(total){

                @Override
                protected void progress(int permille) {
                    1.textualProgress(out, permille);
                }
            };
        }

        long currentProgress(boolean incremental, long value) {
            this.currentProgress = incremental ? this.currentProgress + value : value;
            return this.currentProgress;
        }

        @Override
        public void update(boolean incremental, long value) {
            int permille = (int)(this.currentProgress(incremental, value) * 1000L / this.total);
            if (permille != this.lastPermille) {
                this.lastPermille = permille;
                this.progress(this.lastPermille);
            }
        }

        @Override
        public void done(long totalProgress) {
            this.done();
        }

        void done() {
            if (this.lastPermille < 1000) {
                this.lastPermille = 1000;
                this.progress(1000);
            }
        }

        protected abstract void progress(int var1);

        static void textualProgress(PrintStream out, int permille) {
            if (permille % 100 == 0) {
                out.printf("%3s%%%n", Integer.toString(permille / 10));
            } else if (permille % 5 == 0) {
                out.print(".");
            }
        }
    }
}

