/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.util.ArrayMap;

abstract class ArrayBasedPrimitive
extends Primitive {
    private volatile PropertyData[] properties;

    ArrayBasedPrimitive(boolean newPrimitive) {
        super(newPrimitive);
    }

    @Override
    protected void setEmptyProperties() {
        this.properties = NO_PROPERTIES;
    }

    private PropertyData[] toPropertyArray(ArrayMap<Integer, PropertyData> loadedProperties) {
        if (loadedProperties == null || loadedProperties.size() == 0) {
            return NO_PROPERTIES;
        }
        PropertyData[] result = new PropertyData[loadedProperties.size()];
        int i = 0;
        for (PropertyData property : loadedProperties.values()) {
            result[i++] = property;
        }
        return result;
    }

    @Override
    public void setProperties(ArrayMap<Integer, PropertyData> properties) {
        this.properties = this.toPropertyArray(properties);
    }

    @Override
    protected PropertyData[] allProperties() {
        return this.properties;
    }

    @Override
    protected PropertyData getPropertyForIndex(int keyId) {
        for (PropertyData property : this.properties) {
            if (property.getIndex() != keyId) continue;
            return property;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void commitPropertyMaps(ArrayMap<Integer, PropertyData> cowPropertyAddMap, ArrayMap<Integer, PropertyData> cowPropertyRemoveMap, long firstProp) {
        if (this.properties == null) {
            return;
        }
        ArrayBasedPrimitive arrayBasedPrimitive = this;
        synchronized (arrayBasedPrimitive) {
            PropertyData existingProperty;
            int i;
            PropertyData[] newArray = this.properties;
            int extraLength = 0;
            if (cowPropertyAddMap != null) {
                extraLength += cowPropertyAddMap.size();
            }
            if (extraLength > 0) {
                newArray = new PropertyData[this.properties.length + extraLength];
                System.arraycopy(this.properties, 0, newArray, 0, this.properties.length);
            }
            int newArraySize = this.properties.length;
            if (cowPropertyRemoveMap != null) {
                block3: for (Integer keyIndex : cowPropertyRemoveMap.keySet()) {
                    for (i = 0; i < newArraySize; ++i) {
                        existingProperty = newArray[i];
                        if (existingProperty.getIndex() != keyIndex.intValue()) continue;
                        int swapWith = --newArraySize;
                        newArray[i] = newArray[swapWith];
                        newArray[swapWith] = null;
                        continue block3;
                    }
                }
            }
            if (cowPropertyAddMap != null) {
                block5: for (PropertyData addedProperty : cowPropertyAddMap.values()) {
                    for (i = 0; i < newArray.length; ++i) {
                        existingProperty = newArray[i];
                        if (existingProperty != null && addedProperty.getIndex() != existingProperty.getIndex()) continue;
                        newArray[i] = addedProperty;
                        if (existingProperty != null) continue block5;
                        ++newArraySize;
                        continue block5;
                    }
                }
            }
            if (newArraySize < newArray.length) {
                PropertyData[] compactedNewArray = new PropertyData[newArraySize];
                System.arraycopy(newArray, 0, compactedNewArray, 0, newArraySize);
                this.properties = compactedNewArray;
            } else {
                this.properties = newArray;
            }
        }
    }
}

