/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.nio.channels.ReadableByteChannel;
import java.util.List;
import java.util.Map;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.impl.nioneo.xa.Command;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptor;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;

public class InterceptingXaLogicalLog
extends XaLogicalLog {
    private final List<Pair<TransactionInterceptorProvider, Object>> providers;
    private final XaDataSource ds;

    InterceptingXaLogicalLog(String fileName, XaResourceManager xaRm, XaCommandFactory cf, XaTransactionFactory xaTf, Map<Object, Object> config, List<Pair<TransactionInterceptorProvider, Object>> providers) {
        super(fileName, xaRm, cf, xaTf, config);
        this.providers = providers;
        this.ds = xaRm.getDataSource();
    }

    @Override
    protected XaLogicalLog.LogDeserializer getLogDeserializer(ReadableByteChannel byteChannel) {
        final TransactionInterceptor first = TransactionInterceptorProvider.resolveChain(this.providers, this.ds);
        XaLogicalLog.LogDeserializer toReturn = new XaLogicalLog.LogDeserializer(byteChannel){

            @Override
            protected void intercept(List<LogEntry> entries) {
                for (LogEntry entry : entries) {
                    if (entry instanceof LogEntry.Command) {
                        LogEntry.Command commandEntry = (LogEntry.Command)entry;
                        if (!(commandEntry.getXaCommand() instanceof Command)) continue;
                        ((Command)commandEntry.getXaCommand()).accept(first);
                        continue;
                    }
                    if (entry instanceof LogEntry.Start) {
                        first.setStartEntry((LogEntry.Start)entry);
                        continue;
                    }
                    if (!(entry instanceof LogEntry.Commit)) continue;
                    first.setCommitEntry((LogEntry.Commit)entry);
                }
                first.complete();
            }
        };
        return toReturn;
    }
}

