/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.centrality;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.neo4j.graphalgo.impl.centrality.ShortestPathBasedCentrality;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPath;
import org.neo4j.graphdb.Node;

public class ParallellCentralityCalculation<ShortestPathCostType> {
    protected SingleSourceShortestPath<ShortestPathCostType> singleSourceShortestPath;
    protected Set<Node> nodeSet;
    List<ShortestPathBasedCentrality<?, ShortestPathCostType>> calculations = new LinkedList();
    protected boolean doneCalculation = false;

    public ParallellCentralityCalculation(SingleSourceShortestPath<ShortestPathCostType> singleSourceShortestPath, Set<Node> nodeSet) {
        this.singleSourceShortestPath = singleSourceShortestPath;
        this.nodeSet = nodeSet;
    }

    public void addCalculation(ShortestPathBasedCentrality<?, ShortestPathCostType> shortestPathBasedCentrality) {
        if (this.doneCalculation) {
            throw new RuntimeException("Trying to add a centrality calculation to a parallell computation that has already been done.");
        }
        this.calculations.add(shortestPathBasedCentrality);
        shortestPathBasedCentrality.doneCalculation = true;
    }

    public void calculate() {
        if (this.doneCalculation) {
            return;
        }
        this.doneCalculation = true;
        for (Node startNode : this.nodeSet) {
            this.singleSourceShortestPath.reset();
            this.singleSourceShortestPath.setStartNode(startNode);
            for (ShortestPathBasedCentrality<?, ShortestPathCostType> calculation : this.calculations) {
                calculation.processShortestPaths(startNode, this.singleSourceShortestPath);
            }
        }
    }
}

