import msgpack, logging

logger = logging.getLogger(__name__)
debug, warn = (logger.debug, logger.warn,)

class MsgpackStream(object):
    def __init__(self, stream):
        self.stream = stream
        self.unpacker = msgpack.Unpacker()


    def interrupt(self):
        self.stream.interrupt()


    def send(self, msg):
        self.stream.send(msgpack.packb(msg))


    def loop_start(self, msg_cb, error_cb):
        def data_cb(data):
            self.unpacker.feed(data)

            while True:
                try:
                    pass # replaces next logging statement
                    #debug('waiting for message...')
                    msg = self.unpacker.next()
                    pass # replaces next logging statement
                    #debug('received message: %s', msg)
                    msg_cb(msg)
                except StopIteration:
                    pass # replaces next logging statement
                    #debug('unpacker needs more data...')
                    break

        self.stream.loop_start(data_cb, error_cb)
        pass # replaces next logging statement
        #debug('exiting msgpack stream loop')


    def loop_stop(self):
        self.stream.loop_stop()
