#!/usr/bin/env python

from os.path import join

from distutils.core import setup

import nesoni

with open(join('nesoni','nesoni-r','R','nesoni_version.R'),'wb') as f:
    print >> f, '#Autogenerated'
    print >> f, 'nesoni_version <- function() { \''+ nesoni.VERSION + '\' }'

setup(name='nesoni',
      version=nesoni.VERSION,
      
      packages = [
          'nesoni', 
          'nesoni.third_party',
          'nesoni.third_party.vcf',
          'treemaker',
      ],
      
      package_data = {
          'treemaker' : ['*.pyx'],
          'nesoni' : ['*.pyx','nesoni-r/DESCRIPTION','nesoni-r/R/*'],                    
      },
      
      scripts=['nesoni_scripts/nesoni'],

      classifiers = [
          'License :: OSI Approved :: GNU General Public License v2 or later (GPLv2+)',
      ],
      url = 'http://bioinformatics.net.au/software.nesoni.shtml',
      author = 'Paul Harrison',
      author_email = 'paul.harrison@monash.edu',
)
