#!/usr/bin/env python3
# coding:utf-8
'''nester5模塊，內容部分來源於head first python，使用範例：
１.定義數組和導入模塊
teststr=[1, 2, 3, ['a', 'b', [100, 200, 300, ['me', 'you']]]]
import nester5
２.指定文件描述符和處理異常
with open("testfile.txt","w") as testfh:
    nester5.print_lol(teststr,indent=1,level=0,fh=testfh

３.檢視文件testfile.txt內容是否生成。
    '''
import sys
def print_lol(the_list, indent=False, level=0, fh=sys.stdin):
    '''這是模nester5模塊中的print_lol函數。其中，參數的含意分別是：
the list：　列表；
indent:     縮進的開關，False指的是默認關閉縮進；
level:      打印每個列表元素時縮進的TAB數目；
fh:         要寫入的文件。'''
    for item in the_list:
        if isinstance(item, list):
            print_lol(item, indent, level+1, fh)
        else:
            if indent:
                for tab_stop in range(level):
                    print("\t", end='', file=fh)
            print(item, file=fh)
