"""
Este é o Módulo "nester.py", e forenece a função chamada print_lol()
que imprime listas que podem ou nao incluir listas aninhadas.
"""
import sys

def print_lol(the_list, ident=False, level=0, fh=sys.stdout):
    """
    Esta funçao requer um argumento posicional chamado "the_list",
    que é qualquer lista Python (de possiveis listas aninhadas).
    Cada item de dados na lista fornecida e´ (recursivamente) impresso na
    tela em sua propria linha.
    Um segundo argumento chamado "level" é usado para inserir tabulações quando
    uma lista aninhada e encontrada.
    """
    for each_item in the_list:
        if isinstance(each_item, list):
            print_lol(each_item, ident, level+1, fh)
        else:
            if ident:
                for tab_stop in range(level):
                    print("\t", end ='',  file=fh)
            print(each_item, file=fh)

