#!/usr/bin/env python
"""
Simple program to combine a bunch of HTML files
into a single "indexed" one.
Specialized for creating NetLogger 'tools' page
"""
import os
import re
import sys

page_header = """<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
"http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta name="generator" content="groff -Thtml, see www.gnu.org">
<meta http-equiv="Content-Type" content="text/html; charset=US-ASCII">
<meta name="Content-Style" content="text/css">
<style type="text/css">
       p     { margin-top: 0; margin-bottom: 0; }
       pre   { margin-top: 0; margin-bottom: 0; }
       table { margin-top: 0; margin-bottom: 0; }
       .toc { position: absolute; top: 10px; left: 10px; max-width: 140px; 
              border: 1px dashed grey;}
       .toc h1 { font-weight: 900; color: "#336"; text-align: center; width: 100%; border-bottom: 1px solid #366;}
       .toc ul { list-style-type: none; padding: 5px; margin: 5px;}
       .section { padding: 0.5em; margin: 20px 0; 
                  background-color: white; border: 2px solid #336; }
       .content { margin: 10px 100px 10px 150px; }
       .content h1 { width: 100%; font-size: 150%; color: #336; }
       hr { display: none; }
       body { background-color: lightblue; font-family: Arial, sans-serif; }
       a { text-decoration: none; color: #448; }
        a:active  {color: #448; }
        a:link {color: #448; }
        a:visited {color: #000; }
        a:hover  {color: #488; }
       .toc { background-color: white; }
</style>
<title>NetLogger tools</title>
</head>
<body>
<a name="top"> </a>
<div class="content">
<h1>NetLogger Tools</h1>
"""
page_footer = """</div></body>
</html>
"""

def section_header(name):
    s = "<div id='%s' class='section'>\n" % name
    return s
    
def section_footer(name):
    s = "<a href='#top'>Top</a>\n<a name='%s'> </a>\n" % name
    s += "</div>\n"
    return s
    
def index(names):
    return """<div class='toc'>
    <h1>Tools</h1>
<ul>
%s
</ul>
</div>
""" % '\n'.join(["<li><a href='#%s'>%s</a></li>" % (n,n) for n in names])
    
def main(cmdline):
    buffered, sections = [ ], [ ]
    ofile = sys.stdout
    files = cmdline[1:]
    files.sort()
    for filename in files:
        bare_file, ext = os.path.splitext(filename)
        f = file(filename)
        printing = False
        for line in f:
            if '</body>' in line:
                break
            if printing:
                if 'http://' in line:
                    m = re.search("http://[^<]*",line)
                    if m:
                        s,e = m.span()
                        href = m.group()
                        line = line[:s] + "<a href='%s'>%s</a>" % (href,href) +\
                               line[e:]                        
                buffered.append(line)
            if '<body>' in line:
                printing = True
                buffered.append(section_header(bare_file))
        buffered.append(section_footer(bare_file))
        sections.append(bare_file)
    ofile.write(page_header)
    ofile.write(index(sections))
    ofile.write(''.join(buffered))
    ofile.write(page_footer)
    
if __name__ == '__main__':
    main(sys.argv)