#!/usr/bin/env python
"""
Make list of tools w/hyperlinks for pasting into
wiki page
"""
import os, glob
import sys
if len(sys.argv) > 1:
    kwd = sys.argv[1].lower()
    if kwd != 'dev':
        sys.stderr.write("usage: %s [dev]\n" % sys.argv[0])
        sys.exit(-1)
else:
    kwd = 'stable'
root = "http://dsd.lbl.gov/NetLogger/download/%s/doc/tools" % kwd
tools = map(lambda p: os.path.splitext(p)[0], glob.glob("*.man"))
print '\n'.join(["* [%s/%s.html %s]" % (root, t, t) for t in tools])
