.TH %(program)s %(section)s "%(month)s %(day)s %(year)s" "version %(version)s" "USER COMMANDS"
.SH NAME
%(program)s \- Check a log file for correctness.
.SH SYNOPSIS
.B %(program)s
.SH DESCRIPTION
Checks that a log file is formatted according to the CEDPS project "Best Practices" guide format (also the one used for NetLogger, not coincidentally). Roughly speaking this format requires name=value pairs, two of which must be a timestamp and event type.
.PP
Files are read from a list given on the command line or, if no files are listed, from standard input. Each line that does not conform is reported to standard output. Warnings and errors are printed to standard error, as well as the optional "progress" (useful for large files). In addition, the user may opt to make a copy of each input file with the offending lines removed (see \fB-c\fP option for details).
.SH OPTIONS
%(options)s
.SH EXAMPLES
.TP
Print out errors in files a.log, b.log, and c.log to stdout:
.B %(program)s a.log b.log c.log
.PP
.TP
Combine valid lines from files a.log, b.log, and c.log into cleaned.log, printing out errors to stderr:
.B %(program)s -cx < a.log b.log c.log > cleaned.log
.PP
.TP
Check file big.log, copying valid lines to big.log.cleaned, and showing progress (and validation errors) to stderr:
.B %(program)s -p -c .cleaned big.log
.SH EXIT STATUS
%(program)s returns zero on success, non-zero on failure
.SH BUGS
None known.
.SH AUTHOR
Dan Gunter (dkgunter (at) lbl.gov))
.SH SEE ALSO
http://dsd.lbl.gov/NetLoggerWiki,
BP format: http://www.cedps.net/wiki/index.php/LoggingBestPractices
