.TH %(program)s %(section)s "%(month)s %(day)s %(year)s" "version %(version)s" "USER COMMANDS"
.SH NAME
%(program)s \- Measure CPU availability by active probing.
.SH SYNOPSIS
.B %(program)s
.SH DESCRIPTION
Measure CPU availability by periodically spawning off a process that spins
in a tight loop, and measuring the amount of the CPU we were able to get
during that time. This should in theory be similar to the amount of resources
a user application could claim.
.PP
For each probe, output is a line with a single floating-point number representing the
estimated available CPU, in the range 0 to 1.
.SH OPTIONS
%(options)s
.SH EXAMPLES
.TP
Run with spin-interval 50ms and nice value of 0:
.B %(program)s -i 50
.PP
.TP
Run, as root, with spin-interval 100ms and nice value of -5:
.B sudo %(program)s -i 50 -n -5
.PP
.SH EXIT STATUS
%(program)s returns zero on success, non-zero on error
.SH BUGS
None known.
.SH AUTHOR
Dan Gunter (dkgunter (at) lbl.gov))
.SH SEE ALSO
http://dsd.lbl.gov/NetLoggerWiki, Unix 'nice' manpage
