.TH %(program)s %(section)s "%(month)s %(day)s %(year)s" "version %(version)s" "USER COMMANDS"
.SH NAME
%(program)s \- Read NetLogger logs as input and output the interval between the .start and .end events.
.SH SYNOPSIS
.B %(program)s
.SH DESCRIPTION
Read NetLogger logs as input and produce as output the interval between the .start and .end events. The output is in either aminimal but human-readable format, the log format (details below), or a simple CSV with the event name, key, and interval.
.PP
Logs are read from standard input, and output is written to standard output. Input lines in the logfile that are not understood, are silently ignored. In all output formats, the time interval value is given as a floating-point number of seconds.
.PP
The CSV format has a header row and three columns: event name, identifier value, and interval. The human-readable format is a simplified version of this that has only the event name and interval, separated by a space (instead of a comma for the CSV format), and no header row.
.PP
For the log format, the event name is constructed by taking the part before '.start' or '.end' and appending '.intvl'. The timestamp is the initial timestamp, and an additional attribute 'nl.intvl=' is added, whose value is the time interval. The attributes found in both .start and .end event are merged. If there are duplicated attributes with different values, then the duplicate is split into two attributes suffixed with '.start' and '.end'.
.PP
If the user specifies event pattern(s), then only those events will be processed. The absence of an event pattern followed by a colon means that the given event represents any event not matched by other event patterns. If no event patterns are given at all, then all .start and .end events are processed using 'event,guid' as the identifying fields.
.SH OPTIONS
%(options)s
.SH EXAMPLES
.TP
Process all .start and .end events in 'in.log', writing to 'out.csv':
.B %(program)s < in.log > out.csv
.PP
.TP
Match events starting with 'airplane' on 'flightno' and all other events on a combination of 'country' and 'city', writing the result as a log file to out.log:
.B %(program)s -t log -i airplane:flightno -i country,city < in.log > out.log
.PP
.SH EXIT STATUS
%(program)s returns zero on success and non-zero on failure
.SH BUGS
From description: "Input lines in the logfile that are not understood, are silently ignored". Minor errors in the input could result in inexplicable processing, or no processing at all.
.SH AUTHOR
Dan Gunter (dkgunter (at) lbl.gov))
.SH SEE ALSO
http://dsd.lbl.gov/NetLoggerWiki
