.TH %(program)s %(section)s "%(month)s %(day)s %(year)s" "version %(version)s" "USER COMMANDS"
.SH NAME
%(program)s \- Run a command and notify by email if it fails.
.SH SYNOPSIS
.B %(program)s
.SH DESCRIPTION
Run the given command with its arguments. If the arguments include a dash
then they need to be quoted (you can quote the whole command if you want).
If return status from the command is non-zero, send the standard output
and standard error, with an appropriate subject line, to the provided email address.
.PP
Email is sent by default to localhost, port 25. Values for the "From:"
and "To:" fields must be provided by the user.
.SH OPTIONS
%(options)s
.SH EXAMPLES
.TP
Run /usr/bin/false, which always fails. Do not send email; write what \fIwould\fP have happened to standard output: 
.B %(program)s
\-\-from user@somehost.com \-\-to user@otherhost.org  \-\-test /usr/bin/false
.TP
Sample output:
.nf
.RS
Connect to localhost:25
To: user@otherhost.org
From: user@somehost.com
Subject: Error on 192.168.1.101 (Macintosh-8.local) from '/usr/bin/false'
Output from '/usr/bin/false':
-- stdout --

-- stderr --

.fi
.RE
.TP
Run nl_pipeline in 'nagios mode', which allows you to include the status in the subject line:
.B %(program)s 
\-b "Look out! %%host says '%%status'" \-f user@somehost.org \-t user@otherhost.com \-g \-p 9999 nl_check_pipeline
.TP
Sample output:
.nf
.RS
Subject: Look out! 192.168.1.101 (Macintosh-8.local) says 'CRITICAL: 3 components not running'
Output from '../../scripts/nagios/nl_check_pipeline':
-- stdout --
CRITICAL: 3 components not running

-- stderr --

.fi
.RE
.SH EXIT STATUS
%(program)s returns zero on success, nonzero on an error.
May dump a stack trace if the SMTP connection fails.
.SH BUGS
No known bugs.
.SH AUTHOR
Dan Gunter (dkgunter (at) lbl.gov))
.SH SEE ALSO
NetLogger home page
.RS
http://dsd.lbl.gov/NetLoggerWiki
.RE

