.TH %(program)s %(section)s "%(month)s %(day)s %(year)s" "version %(version)s" "USER COMMANDS"
.SH NAME
%(program)s \- Program to manage the nl_parser and nl_loader
.SH SYNOPSIS
.B %(program)s [options]
.SH DESCRIPTION
Program to manage the nl_parser and nl_loader.
.PP
Starts both programs as daemons. Then periodically sends the parser a HUP signal so
it re-reads its configuration file and, more importantly, picks up on input files that
have come or gone since the last configuration.
.PP
Several of the "options" are required directory locations: where to read the configuration files
for the nl_loader and nl_parser (they must be in the same directory), where to write program logs,
and where to write the nl_loader and nl_parser process id files.
.PP
For testing and debugging, you can use the
.B -n/--no-action
option, which tells the program to just check that it could have started both
the nl_parser and the nl_loader, and report how. 
For debugging while running, you can also set the logging
verbosity with
.B -v/--verbose
and run in the foreground with
.B -D/--no-daemonize
.
.PP
For controlling the location of the nl_parser and nl_loader, add the
.B -s/--sys-path
option, which looks for nl_parser and nl_loader on the current PATH instead of
getting the full real path of the nl_pipeline program and using that prefix.
.SH OPTIONS
%(options)s
.SH EXAMPLES
.TP
Run with configurations /etc/netlogger/{nl_loader.conf, nl_parser.conf}, placing PIDs in /var/run/netlogger/{nl_loader.pid, nl_parser.pid}, and logging status to /var/log/nl_pipeline.log:
.B %(program)s
\-c /etc/netlogger -p /var/run/netlogger -l /var/log
.PP
.TP
Same as previous example, except don't really run -- just show errors if they would occur.
.B %(program)s
\-c /etc/netlogger -p /var/run/netlogger -l /var/log 
.B -n
.SH EXIT STATUS
%(program)s returns zero on success, 255 (via sys.exit(-1)) on failure
.SH BUGS
No known bugs.
.SH AUTHOR
Dan Gunter (dkgunter (at) lbl.gov))
.SH SEE ALSO
NetLogger home page
.RS
http://dsd.lbl.gov/NetLoggerWiki
.RE
