.TH %(program)s %(section)s "%(month)s %(day)s %(year)s" "version %(version)s" "USER COMMANDS"
.SH NAME
%(program)s \- Write a NetLogger-formatted message.
.SH SYNOPSIS
.B %(program)s [options]
.SH DESCRIPTION
Write one NetLogger-formatted messge to standard output, TCP, or UDP.
.PP
Any number (well, up to the limit of your command-line processor) of
name=value pairs can be given as arguments. These will be copied to the
output, i.e. included in the output log along with the standard values
of ts=<timestamp> and event=<event_name>.
.SH OPTIONS
Note: single-letter options in upper-case
control 
.B "how"
things are logged, whereas lower-case options control 
.B "what"
is logged)
.PP
%(options)s
.SH EXAMPLES
.TP
Write the default message:
.B %(program)s
.PP
.TP
Write a message with a host, guid, and attributes 'foo' and 'bar':
.B "%(program)s -g -i foo=12345 bar='hello, world'"
.PP
.TP
Write a syslog-formatted message to the standard syslog UDP port (514):
.B "%(program)s -g -U msg='hello, world'"
.PP
.SH EXIT STATUS
%(program)s returns zero on success, non-zero on error
.SH BUGS
The
.B \-i
(host) option always uses the default interface.
.PP
There is no way to write a message with a user-defined timestamp, the time is
always "now".
.SH AUTHOR
Dan Gunter (dkgunter (at) lbl.gov))
.SH SEE ALSO
http://dsd.lbl.gov/NetLoggerWiki
