"""
Module with common code for querying 'NetLogger' databases.
"""
__rcsid__ = "$Id$"
__author__ = 'Dan Gunter'

import logging
from netlogger import nlapi
from netlogger import nllog

# Logging
log = None
def activateLogging(name=__name__):
    global log
    log = nllog.getLogger(name)

def doQuery(module, conn, **kw):
    pass

reserved = ('event', 'ts', 'level')

def writeEvent(writer, event, only=None, exclude=None):
    if not event:
        return
    e2 = { }
    for n, v in event.items():
        if n not in reserved and \
                (exclude is None or (n not in exclude)) and \
                (only is None or (n in only)):
            e2[n] = v
    writer.write(event['event'], event['ts'], 
                 event.get('level',nlapi.Level.INFO), **e2)

def equalOrLike(expr, table, param, col="value"):
    restriction = "%s.%s " % (table, col)
    if '%' in expr:
        restriction += "like %%(%s)s" % param
    else:
        restriction += "= %%(%s)s" % param
    return restriction
