"""
Describe database contents
"""
__rcsid__ = "$Id$"
__author__ = 'Dan Gunter'

import logging
from netlogger import nlapi
from netlogger import nllog
from base import writeEvent, equalOrLike

# Logging
log = None
def activateLogging(name=__name__, **kw):
    global log
    log = nllog.getLogger(name, **kw)

def doQuery(module, conn, ofile=None, batch=50, **kw):
    conn.execute("set time_zone = '+0:00'") # UTC
    cursor = conn.cursor()
    cursor.execute("select count(id) from event")
    row = cursor.fetchone()
    num_events = int(row[0])
    ofile.write("%d events in database\n" % num_events)
    cursor.execute("select id, name from event_type")
    breakdown = [ ]
    while 1:
        row = cursor.fetchone()
        if row is None:
            break
        et_id, name = row
        c2 = conn.cursor()
        c2.execute("select count(id) from event where et_id = %s" % et_id)
        row = c2.fetchone()
        num_for_event = int(row[0])
        breakdown.append((num_for_event, name))
    breakdown.sort(reverse=True)
    for num_for_event, name in breakdown:
        ofile.write("  %-6d %s\n" % (num_for_event, name))


