#!/usr/bin/env python
"""
Unittests for <module>.py
"""
__author__ = 'Dan Gunter dkgunter@lbl.gov'
__rcsid__ = '$Id: testParseCsaAcct.py 904 2008-08-06 20:37:10Z dang $'

import unittest
import testBase
from netlogger.parsers.modules import csa_acct

class TestCase(testBase.BaseParserTestCase):
    """Unit test cases.
    """
    basename = "csa_acct-"
    parser_class = csa_acct.Parser

    def testBasic(self):
        """Parse the sample log
        """
        filename = "basic.log"
        # count lines in file
        expected = len(list(file(self.getFullPath(filename))))
        # Try default (one event) mode
        self.checkGood(filename=filename, num_expected=expected)
        # Try two-event mode
        self.checkGood(filename=filename, num_expected=expected*2, 
                       parser_kw = dict(one_event=False))
        
# Boilerplate to run the tests
def suite(): 
    return testBase.suite(TestCase)
if __name__ == '__main__':
    testBase.main()


