#!/usr/bin/env python
"""
Unittests for pbs_parser.py
"""
__author__ = 'Shreyas Cholia scholia@lbl.gov'
__rcsid__ = '$Id: testParsePBS.py 947 2008-08-28 11:07:51Z dang $'

import unittest
import testBase
from netlogger.parsers.modules import pbs

class TestCase(testBase.BaseParserTestCase):
    """Unit test cases.
    """
    basename = "pbs_parser-"
    parser_class = pbs.Parser

    def testBasic(self):
        """Basic test of pbs_parser
        """
        # the full path should be data/pbs_parser-sample.log
        filename = "sample.log"
        # count lines in file
        expected = len(list(file(self.getFullPath(filename))))
        # Check if all lines got parsed
        self.checkGood(filename=filename, num_expected=expected)
        
# Boilerplate to run the tests
def suite(): 
    return testBase.suite(TestCase)
if __name__ == '__main__':
    testBase.main()


