#!/usr/bin/env python
"""
Unittests for parse_sge.py
"""
__author__ = 'Dan Gunter dkgunter@lbl.gov'
__rcsid__ = '$Id: testParseSGE.py 796 2008-06-03 21:40:28Z dang $'

import testBase
import unittest
from netlogger.parsers.modules.sge import Parser

class TestCase(testBase.BaseTestCase):
    EVENT = "all.q:pc1018.nersc.gov:dayabay:jianglai:test_neutron_CDR_near_DYB_r484_c2.command:2779793:sge:0:1167554073:1167562126:1167567604:0:0:5478:5207:32:0.000000:0:0:0:0:339102:43557:0:0.000000:0:0:0:0:0:0:other:defaultdepartment:NONE:1:0:5239.000000:1024.547343:0.000000:-l h_cpu=21600,h_stack=10240K,h_vmem=1100M -P other:0.000000:NONE:219533312.000000\n"
    def testStartEnd(self):
        """Test for correctly parsed values in start and end event"""
        self.setInput(self.EVENT)
        parser = Parser(self.sio, raw=True)
        start = parser.next()
        self.failUnless(start,"No start event")
        end = parser.next()
        self.failUnless(end, "No end event")
        self.failUnless(start['ts'] <= end['ts'], "Time is backwards")
        self.assertEquals(end['maxvmem'], 219533312.0)
        self.assertEquals(start['job.id'], 2779793)
        self.assertEquals(end['job.id'], 2779793)

    def testOneEvent(self):
        """Test for correctly parsed values in single event"""
        self.setInput(self.EVENT)
        parser = Parser(self.sio, one_event=True, raw=True)
        job = parser.next()
        self.assert_(job,"No event")
        self.assert_(job['dur'] >= 0, "Time is backwards")
        self.assertEquals(job['maxvmem'], 219533312.0)
        self.assertEquals(job['job.id'], 2779793)

# Boilerplate to run the tests
def suite(): 
    return testBase.suite(TestCase)
if __name__ == '__main__':
    testBase.main()
