#!/usr/bin/env python
"""
Unittests for analysis/startend.py
"""
__author__ = 'Dan Gunter dkgunter@lbl.gov'
__rcsid__ = '$Id: testStartend.py 788 2008-06-02 17:11:49Z dang $'

import testBase
import unittest
from netlogger.analysis import startend

class TestCase(unittest.TestCase):
    event_source_1 = [
        {'ts':'2007-12-18T19:00:17.880754Z',
         'event':'something.else', 'value':1 },
        {'ts':'2007-12-18T19:00:18.880754Z',
         'event':'a.start', 'guid':'792d15d6-ad9b-11dc-a674-001b63926e0d'},
        {'ts':'2007-12-18T20:00:19.880754Z',
         'event':'b.start', 'guid':'792d15d6-ad9b-11dc-a674-001b63926e0d'},
        {'ts':'2007-12-18T20:00:20.880754Z',
         'event':'a.end', 'guid':'792d15d6-ad9b-11dc-a674-001b63926e0d'},
        {'ts':'2007-12-18T20:00:20.980754Z',
         'event':'b.end', 'guid':'792d15d6-ad9b-11dc-a674-001b63926e0d'},
    ]
    def _testOne(self, events, non_se, scanned_a):
        m = startend.StartEndMatcher(idlist=('event','guid'), max_time=3600, scan=2)
        for i, e in enumerate(events):
            added = m.add(e)
            self.assert_(i == non_se or added, "add(event) at %d" % i)
            if len(m) > 0:
                if i == scanned_a:
                    r = m.getResults()[0]
                    self.assertEquals(r[1], None, "non-empty end")
                else:
                    r = m.getResults()[0]
                    self.assertEquals(r[0]['event'], 'b.start', '%d: b.start not returned' % i) 
                    self.assertEquals(r[1]['event'], 'b.end', '%d: b.end not returned' % i) 
                  
    def testOneOrdered(self):
        """Test correctness with one StartEnd class and ordered events.
        """        
        self._testOne(self.event_source_1, 0, 3)

    def testOneUnordered(self):
        """Test correctness with one StartEnd class and out-of-order events.
        """
        # shuffle
        esrc = self.event_source_1[:]
        first = esrc[0]
        esrc = esrc[1:] + [first]
        # test 
        self._testOne(esrc, len(esrc) - 1, 2)
         

# Boilerplate to run the tests
def suite(): 
    return testBase.suite(TestCase)
if __name__ == '__main__':
    testBase.main()
