#!/usr/bin/env python
"""
Generate a manpage

usage: gen_manpage.py program [template=manpage-template.3]
"""
import os
import re
from subprocess import Popen, PIPE, STDOUT
import sys
import time

SECTION = '1'

def _debug(s):
    sys.stderr.write(s)
    sys.stderr.write('\n')

opt_re = re.compile('(?P<shortopt>-[a-zA-Z](?: \w+)?)?(?:, )?\s*(?P<longopt>--[a-zA-Z_\-=]+)?(?P<desc>.*)')
def run(prog, template):
    d = { 'program' : os.path.basename(prog), 'options' : '',
          'section':SECTION  }
    t = time.time()
    ct = time.ctime(t).split()
    d['year'], d['month'], d['day'] = ct[4], ct[1], ct[2]
    try:
        p = Popen((prog,'--version'), stderr=STDOUT, stdout=PIPE)
    except OSError, E:
        print >>sys.stderr,"error running program %s: %s" % (prog, E)
        sys.exit(1)
    d['version'] = p.stdout.readline().strip()
    p.wait()
    _debug("running: %s -h" % prog)
    p = Popen((prog,'-h'), stderr=STDOUT, stdout=PIPE)
    inopts, curopt, insubsec = False, '', False
    for line in p.stdout.readlines():
    	indent = len(line) - len(line.lstrip())
        s = line.strip()
        #print d
        if not inopts:
            if s.lower().startswith('options:'): 
                inopts = True
                curdesc, curopt = '',''
        elif s.endswith(':'):#'options:' in s.lower():
            if curopt != '':
                d['options'] += '.TP\n%s\n%s\n' % (curopt, curdesc)
            # options subsection
            #print "@subsection"
            inopts = True
            insubsec = True
            curdesc, curopt = '',''
            d['options'] += ".SS %s\n" % s
        elif s.startswith('-') and indent < 6:
            insubsec = False
            if curopt != '':
                d['options'] += '.TP\n%s\n%s\n' % (curopt, curdesc)
            m = opt_re.search(s)
            curopt = ''
            if m.group('shortopt'):
                curopt += r'\fB' + m.group('shortopt').replace('-', '\-') + ' '
            if m.group('longopt'):
                curopt += r'\fB' + m.group('longopt').replace('-', '\-')
            if m.group('desc'):
                curdesc = m.group('desc').strip()
            else:
                curdesc = ''
        elif insubsec:
            d['options'] += "%s\n" % s
        else:
            curdesc += ' ' + s
    if curopt != '':
        d['options'] += '.TP\n%s\n%s\n' % (curopt, curdesc)
    p.wait()
    # slurp template
    template_str = ''.join(template.readlines())
    # return populated template
    return template_str % d


if __name__ == '__main__':
    _prog = os.path.basename(sys.argv[0])
    n = len(sys.argv)
    if n != 2:
        print >>sys.stderr,"usage: %s program" % _prog
        sys.exit(1)
    program = sys.argv[1]
    root, ext = os.path.splitext(program)
    rel_root = os.path.basename(root)
    template = "%s.man" % rel_root
    ifile = None
    try:
        ifile = file(template)
    except IOError, E:
        print >>sys.stderr, """error: program '%s' needs template file in
current directory called '%s'""" % (program, template)
        sys.exit(1)    
    s = run(program, ifile)
    manpage = "%s.%s" % (rel_root, SECTION)
    if os.path.exists(manpage):
        backup = "%s~" % manpage
        if os.path.exists(backup):
            os.unlink(backup)
        os.rename(manpage, backup)
        print >>sys.stderr,"old page backed up to %s" % backup
    ofile = file(manpage, 'w')
    ofile.write(s)
    print >>sys.stderr,"manpage written to %s" % manpage
        
