.TH %(program)s %(section)s "%(month)s %(day)s %(year)s" "version %(version)s" "USER COMMANDS"
.SH NAME
%(program)s \- Convert floating-point dates to NetLogger string dates, and vice-versa
.SH SYNOPSIS
.B %(program)s
.SH DESCRIPTION
This simple utility just converts one or more dates from the number of seconds since the Epoch (1/1/1970 00:00:00) to
the ISO8601 string representation YYYY-MM-DDThh:mm:ss.ffffffZ, or vice-versa. The type of a given input is auto-detected.
NetLogger's own parsing and formatting routines are used, so this utility doubles as a sanity-check of those functions.
.PP
.TP
The list of dates is read from the command line, and output is printed to standard output in the form:
.B input = output
.PP
If no date is provided, then the current time is used (as returned by Python's time.time() function).
.SH OPTIONS
%(options)s
.SH EXAMPLES
.TP
Print out the current time in both formats:
.B %(program)s
.PP
.TP
Convert one floating-point and one string date:
.B %(program)s 1185733072.567627 2007-07-29T18:17:52.567627Z
.PP
.SH EXIT STATUS
%(program)s always returns zero (success)
.SH BUGS
None known.
.SH AUTHOR
Dan Gunter (dkgunter (at) lbl.gov))
.SH SEE ALSO
http://dsd.lbl.gov/NetLoggerWiki
