.TH %(program)s %(section)s "%(month)s %(day)s %(year)s" "version %(version)s" "USER COMMANDS"
.SH NAME
%(program)s \- A script for running user defined queries on a database (generated by netlogger or otherwise).
.SH SYNOPSIS
%(program)s runs queries on a database using the various parameters supplied on the command line or via a configuration file.
.SH DESCRIPTION
%(program)s is a script for running user defined queries on a database.
The query file takes various command line parameters as user input and queries the database according to the user defined queries and input parameters. The queries to be executed should be written in a config file which nl_dbquery will read. The queries in the config file are generalised so that the database connection and other specific parameters are separated from the actual query statements themselves. This way these parameters can be changed without having a need to change the queries themselves. 

.SH OPTIONS
%(options)s


.SH USAGE
.TP
\fBConfiguration File 
.PP
This is part of a sample configuration file which gives information about different sections and their usage:

[DEFAULT]
# put defaults here
# These are the query sections

[how_many_jobs]
   desc = "How many jobs ran on a given day"
   query = "select count(id) from event where TIMERANGE and name = 'pegasus.invocation';"

[jobs_on_hosts]
   desc = "How many jobs ran on given hosts" 
   query = "select count(id), value from event join attr on e_id = id where event.name = 'pegasus.invocation' and attr.name = 'host' group by value;"


[DEFAULT] has all the default values/paarmeters to be used by the queries
To add a new query to the configuration file add that section like [how_may_jobs] above

desc: is a description of the query which will be read by the -l/--list option

query: this is the actual query statement.The values of the TIMERANGE parameter can be substituted at the runtime from the command line (see -s/--start and -e/--end option for more information)



.SH EXAMPLES
.TP
.B nl_dbquery -c filename -p mysql://localhost -d dbname -q 1 -s "3 weeks ago" -e "1 week 2 days ago" 
.PP
Description of what this example does:
This example runs the script on a configuration file named filename for a MySQL database running at localhost. The name of the database is dbname and the query to be executed is query 1. The start date for the query is "3 weeks ago" while the end date for it is "1 week 2 days ago"
.SH EXIT STATUS
%(program)s returns 0 on success and a non-zero value on failure. 
.SH BUGS
No known bugs.
.SH AUTHOR
Binit S Bhatia (bsbhatia (at) lbl.gov)
.SH SEE ALSO
NetLogger home page
.RS
http://acs.lbl.gov/NetLoggerWiki
.RE

