.TH %(program)s %(section)s "%(month)s %(day)s %(year)s" "version %(version)s" "USER COMMANDS"
.SH NAME
%(program)s \- Find bottleneck from NetLogger transfer summary logs.
.SH SYNOPSIS
.B %(program)s [options]
.SH DESCRIPTION
Determine the bottleneck from NetLogger logs that show the disk and network read and write bandwidths. The input is a NetLogger log, specifically the one produced by NetLogger's "transfer" API, although in reality the only fields that need to be present are the correct event name (see below) and:
.PP
\fBr.s\fP: sum of bytes/sec ratio
.PP
\fBnv\fP: number of items in the sum for 'r.s'
.PP
The event name is expected to contain one of four values indicating the component being measured; "disk.read", "disk.write", "net.read", and "net.write". As long as this string appears somewhere in the event name, it will be recognized.
.PP
The output is the bottleneck, or "unknown". Optionally (with \fB-v\fP), the sorted list of bandwidths is written as well.
.PP
Although the options provide for multiple bottleneck algorithms, at present only one is implemented -- the "simple" algorithm that basically looks for the smallest number and labels that the bottleneck if it is more than 15%% smaller than the next smallest. For details see the netlogger.analysis.bottleneck module. 
.PP
Note that parse errors in the input files will be silently ignored. If the \fB-d\fP flag is given, then parse errors will show up as debug messages in the log, but they still will not stop the program.
.SH OPTIONS
%(options)s
.SH EXAMPLES
.TP
Determine the bottleneck from my_transfer.log:
.B %(program)s my_transfer.log
.PP
.SH EXIT STATUS
%(program)s returns zero on success, and non-zero on error
.SH BUGS
None are known.
.SH AUTHOR
Dan Gunter (dkgunter (at) lbl.gov))
.SH SEE ALSO
http://dsd.lbl.gov/NetLoggerWiki
