.TH %(program)s %(section)s "%(month)s %(day)s %(year)s" "version %(version)s" "USER COMMANDS"
.SH NAME
%(program)s \- Make simple queries on a database filled by nl_loader
.SH SYNOPSIS
.B %(program)s [options] [database name=value keywords]
.SH DESCRIPTION
%(program)s provides a command-line interface for connecting to a
relational database and making some common types of queries on a 
database of log events created and filled by the nl_loader program.
.PP
A single invocation of the program connects to the database, makes the
query, then writes the results (to stdout, by default).
.PP
.SH OPTIONS
%(options)s
.SH EXAMPLES
.TP
Connect to MySQL running on the default port on localhost, using the configuration in "~/.my.cnf", using the database 'testdb' and perform the query, "Give me events named my.event and all events linked to these by an identifier, up to 100 events total":
.B %(program)s
-d mysql -u localhost read_default_file="~/.my.cnf" db=testdb --event=my.event --depth=-1
.TP
Connect to MySQL running on the default port on localhost, using the configuration in "~/.my.cnf", using the database 'testdb' and perform the query, "Give me up to 100 events that occurred on February 5, 2008":
.B %(program)s
-d mysql -u localhost read_default_file="~/.my.cnf" db=testdb --time=2008-02-05 --limit=100
.TP
Connect to MySQL running on the default port on localhost, using the configuration in "~/.my.cnf", using the database 'testdb' and perform the query, "Give me up to 10 events total from the set of all events, E1, with a guid that matches the given value and all events, E2, that share any other identifier with E1":
.B %(program)s
-d mysql -u localhost read_default_file="~/.my.cnf" db=testdb --depth=1 --filter="guid='B902C576-46EB-4CBF-BE99-DF29BD71FC29'" --limit=10
.SH EXIT STATUS
%(program)s returns zero on success, -1 on failure.
.SH BUGS
No known bugs, but this version has only been tested with MySQL, so it
is possible some of the commands used may fail on other databases.
.SH AUTHOR
Dan Gunter (dkgunter (at) lbl.gov))
.SH SEE ALSO
NetLogger home page
.RS
http://dsd.lbl.gov/NetLoggerWiki
.RE

