.TH %(program)s %(section)s "%(month)s %(day)s %(year)s" "version %(version)s" "USER COMMANDS"
.SH NAME
%(program)s \- Re-format NetLogger logs.
.SH SYNOPSIS
.B %(program)s
.SH DESCRIPTION
Reformats the semi-structured keyword and value pairs of the NetLogger
format for readability or importing into Excel, R, or other programs that require
tabular data.
.PP
The time and event is always shown, although the time can be formatted
either as an absolute ISO timestamp (the default), or as a number of seconds
since the first or previous event. An arbitrary prefix can be stripped from
event names (names without that prefix are of course left alone).
.PP
The default delimiter between columns is a space, but this can be changed to
make, e.g., comma-separated values. Currently no quoting is done.
.PP
Special support for identifiers is provided with the -t/--tiny-id option,
which replaces the value of the identifier with a short (4-character) locally
unique value. This value is random, but the seed is always the same and the
algorithm is deterministic, so the chosen value will be the same for successive 
invocations. 
.SH OPTIONS
%(options)s
.SH EXAMPLES
.TP
Put the viewer in a pipeline between the application and a pager, showing host name and GUID attributes (in addition to base attributes):
my-application | 
.B %(program)s 
\-gi | less
.PP
.TP
Run the viewer on a bunch of files, showing some user-defined attributes:
.B %(program)s 
\-a foo \-a bar *.log
> combined.log
.PP
.TP
Run the viewer so that it displays time-deltas, guid, event name with a prefix stripped, and any "identifier" attributes. This particular set of values is useful for the Globus 4.2 containerLog:
.B %(program)s 
\-diIgmt \-\-namespace=org.globus.  containerLog 
.SH EXIT STATUS
Always succeeds, returning 0.
.SH BUGS
None known.
.SH AUTHOR
Dan Gunter (dkgunter (at) lbl.gov))
.SH SEE ALSO
.B nl_csv(1)
.br
NetLogger home page
.RS
http://dsd.lbl.gov/NetLoggerWiki
.RE
Apache Common Log Format
.RS
http://httpd.apache.org/docs/2.2/logs.html
.RE
