#!/usr/bin/env python
"""
Load and run all unit tests.

dang:5/23/08 - Modified to work when invoked as "python testAll.py" or
               from "python setup.py test" at the top level
"""
__author__ = 'Dan Gunter dkgunter@lbl.gov'
__rcsid__ = '$Id: testAll.py 924 2008-08-19 17:28:14Z dang $'

from glob import glob
import os
import sys
from unittest import defaultTestLoader, TestResult, TestSuite
from unittest import TextTestRunner

def suite(modules=[]):
    if not modules:
        path = os.path.realpath(os.path.dirname(__file__))
        for mod in glob(os.path.join(path, "test*.py")):
            base_mod = os.path.basename(mod).rsplit('.',1)[0]
            full_mod = "netlogger.tests." + base_mod
            modules.append(full_mod)
    print "Modules:"
    print '\n'.join(modules)
    tests = defaultTestLoader.loadTestsFromNames(modules)
    return TestSuite(tests)

if __name__ == "__main__":
    verbose = False
    if len(sys.argv) == 1:
        modules = [ ]
    elif len(sys.argv) == 2 and sys.argv[1] == '-v':
        modules = [ ]
        verbose = True
    else:
        modules = sys.argv[1:]    
    ste = suite(modules)
    if verbose:
        print "Running modules:"
        for mod in modules:            
            if mod.startswith("netlogger.tests."):
                name = mod[16:]
            else:
                name = mod
            if name not in ('testAll',):
                print name
    TextTestRunner().run(ste)
