#!/usr/bin/env python
"""
Unittests for util.IncConfigObj class
"""
__author__ = 'Dan Gunter dkgunter@lbl.gov'
__rcsid__ = '$Id: testIncConfigObj.py 1003 2008-09-09 15:58:53Z dang $'

from netlogger import configobj
import tempfile
import unittest
import testBase
from netlogger.util import IncConfigObj

class TestCase(testBase.BaseTestCase):
    """Unit test cases.
    """
    def setUp(self):
        self.debug_("create files")
        self.files = [tempfile.NamedTemporaryFile() for i in range(4)]
        self.files[0].write("# main file\n"
                            " @include %s\n"
                            "[hello]\n"
                            "message = \"hello, $name\"\n"
                            "@include %s\n"
                            "@include %s\n"
                            % (self.files[1].name, self.files[2].name,
                               self.files[3].name))
        self.files[1].write("name = Dan\n")
        self.files[2].write("[goodbye]\n"
                            "message = \"goodbye, $name\"\n")
        self.files[3].write("[sayonara]\n"
                            "message = \"sayonara, $name\"\n")
        map(lambda f: f.seek(0), self.files)
        self.debug_("main file: %s" % self.files[0].name)
        self.debug_("included files: %s" % ','.join([n.name for n in self.files[1:]]))

    def testInclude(self):
        """Test IncConfigObj @include directive
        """
        self.debug_("configure from file '%s'" % self.files[0].name)
        obj = IncConfigObj(self.files[0].name, interpolation='Template', 
                           file_error='True')        
        for salut in 'hello', 'goodbye', 'sayonara':
            self.assert_(obj[salut]['message'] == "%s, Dan" % salut)
         
    def testIncludeErr(self):
        """Test error reporting for @include
        """
        self.files[1].seek(0, 2)
        self.files[1].write("- bad -\n")
        self.files[1].flush()
        try:
            self.debug_("configure from file '%s'" % self.files[0].name)
            obj = IncConfigObj(self.files[0].name, 
                               interpolation='Template', file_error='True')
        except configobj.ConfigObjError, E:
            msg = str(E)
            missing = self.files[1].name
            self.assert_(msg.find(missing) > 0, "couldn't find '%s' in error message" % missing)
        
# Boilerplate to run the tests
def suite(): 
    return testBase.suite(TestCase)
if __name__ == '__main__':
    testBase.main()
