#!/usr/bin/env python
"""
Unittests for netlogd.py
"""
__author__ = 'Dan Gunter dkgunter@lbl.gov'
__rcsid__ = '$Id: testNetlogd.py 788 2008-06-02 17:11:49Z dang $'

import os
import unittest
from tempfile import mkstemp
import testBase

class TestCase(testBase.BaseTestCase):
    program = testBase.scriptPath('netlogd')

    long_args = ['--flush', '--kill', '10m', '--port', '33553', '--rollover',
                    '100kb', '--udp', '--quiet', '--verbose']

    short_args = ['-f', '-k', '10m', '-p', '33553', '-r', '100MB', '-U',
                    '-q', '-v']

    def testArgsBasic(self):
        """Test different combinations of command line arguments.
        """
        # these should work
        self.cmd(['-h'], 'wait')
        self.cmd([''])
        # these should fail
        self.cmd(['--foobar'], should_fail=True)

    def testArgsAllExceptFile(self):
        """Test the whole batch of short args / long args
        """
        self.cmd(self.short_args)
        self.cmd(self.long_args)

    def testArgsFile(self):
        """Test args including output files
        """
        tempfiles = mkstemp()[1], mkstemp()[1]
        self.cmd(self.short_args + ['-o', tempfiles[0], '-o', tempfiles[1]])
        self.cmd(self.long_args + ['--output', tempfiles[0],
                                   '--output', tempfiles[1]])
        for f in tempfiles:
            os.unlink(f)
        
 

# Boilerplate to run the tests
def suite(): 
    return testBase.suite(TestCase)
if __name__ == '__main__':
    testBase.main()
