#!/usr/bin/env python
"""
Unittests for parse_gatekeeper.py
"""
__author__ = 'Dan Gunter dkgunter@lbl.gov'
__rcsid__ = '$Id: testParseGatekeeper.py 764 2008-05-16 19:50:34Z dang $'

import sys
import testBase
import unittest
from netlogger.parsers.modules.gk import Parser

class TestCase(testBase.BaseTestCase):
    SUCCESS = """TIME: Thu Nov  9 00:06:28 2006
 PID: 6577 -- Notice: 6: Got connection 128.105.121.51 at Thu Nov  9 00:06:28 2006
TIME: Thu Nov  9 00:06:28 2006
 PID: 6577 -- Notice: 5: Authenticated globus user: /DC=org/DC=doegrids/OU=People/CN=Somebody (Grid Exerciser) 771829
TIME: Thu Nov  9 00:06:28 2006
 PID: 6577 -- PRIMA INFO  Mapping service "https://cmssrv08.fnal.gov:8443/gums/services GUMSAuthorizationServicePort" returned local user "gridex" for globus user "/DC=org/DC=doegrids/OU=People CN=Somebody (Grid Exerciser) 771829" 
TIME: Thu Nov  9 00:06:28 2006
 PID: 6577 -- Notice: 0: GRID_SECURITY_HTTP_BODY_FD=8
TIME: Thu Nov  9 00:06:28 2006
 PID: 6577 -- Notice: 5: Requested service: jobmanager-condor
TIME: Thu Nov  9 00:06:28 2006
 PID: 6577 -- Notice: 5: Authorized as local user: gridex
TIME: Thu Nov  9 00:06:28 2006
 PID: 6577 -- Notice: 5: Authorized as local uid: 10657
TIME: Thu Nov  9 00:06:28 2006
 PID: 6577 -- Notice: 5:           and local gid: 10657
TIME: Thu Nov  9 00:06:28 2006
 PID: 6577 -- Notice: 0: executing /storage/local/data1/osg-ce/globus/libexec/globus-job-manager
TIME: Thu Nov  9 00:06:28 2006
 PID: 6577 -- Notice: 0: GATEKEEPER_JM_ID 2006-11-09.00:06:28.0000006577.0000000000 for DC=org/DC=doegrids/OU=People/CN=Alan De Smet (Grid Exerciser) 771829 on 128.105.121.51
TIME: Thu Nov  9 00:06:28 2006
 PID: 6577 -- Notice: 0: GRID_SECURITY_CONTEXT_FD=11
TIME: Thu Nov  9 00:06:28 2006
 PID: 6577 -- Notice: 0: Child 6639 started
"""    
    def testSuccess(self):
        """gatekeeper logs for a successful session.
        """
        self.setInput(self.SUCCESS)
        parser = Parser(self.sio, raw=True)
        event = testBase.getNextEvent(parser)
        self.failUnless(event['event'].endswith('.conn'), 
                        "First event '%s' should end with .conn" % 
                        event['event'])
        event = testBase.getNextEvent(parser)
        self.failUnless(event['event'].endswith('auth'),
                        "Second event '%s' should end with '.auth'" %
                        event['event'])


# Boilerplate to run the tests
def suite(): 
    return testBase.suite(TestCase)
if __name__ == '__main__':
    testBase.main()
