#!/usr/bin/env python
"""
Unittests for parse_gridftp.py
"""
__author__ = 'Dan Gunter dkgunter@lbl.gov'
__rcsid__ = '$Id: testParseGridftp.py 676 2008-04-10 14:12:08Z dang $'

import testBase
import unittest
from netlogger.parsers.modules.gridftp import Parser

class TestCase(testBase.BaseTestCase):
    NBYTES = 55
    DUR = 3.2102 - 2.763298
    EVENT = """DATE=20070215110703.2102 HOST=pdsfgrid1.nersc.gov PROG=globus-gridftp-server NL.EVNT=FTP_INFO START=20070215110702.763298 USER=rosheck FILE=//tmp/YY5raYFdo5.local_out_moved BUFFER=0 BLOCK=262144 NBYTES=%d VOLUME=/ STREAMS=1 STRIPES=1 DEST=[129.79.4.64] TYPE=RETR CODE=226
""" % ( NBYTES,)
    def testDefaults(self):
        """GridFTP INFO event, default parsing options"""
        self.setInput(self.EVENT)
        parser = Parser(self.sio, raw=True)
        # check data
        event = parser.next()
        self.failUnless(event)
        self.assertEqual(event['nbytes'], self.NBYTES)

    def testOneEvent(self):
        """GridFTP INFO event, output as a single event"""
        self.setInput(self.EVENT)
        parser = Parser(self.sio, one_event=True)
        # check data
        event = parser.next()
        self.failUnless(event)
        # check output lines
        self.failUnless('guid=' in event)
        self.failIf('.start' in event)
        try:
            event = parser.next()
            self.fail("Got more than one event")
        except StopIteration:
            pass


# Boilerplate to run the tests
def suite(): 
    return testBase.suite(TestCase)
if __name__ == '__main__':
    testBase.main()
