#!/usr/bin/env python
import os, random, time, uuid, socket, sys, syslog

SYSLOG_HOST, SYSLOG_PORT = 'netlogger.lbl.gov', 5141
_sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
#_sock.connect((SYSLOG_HOST, SYSLOG_PORT))

try:
    _ip = socket.gethostbyname(socket.getfqdn())
except:
    _ip = '127.0.0.1'

def _syslogHeader(host=_ip, program="fake_job.py"):
    """Return string to be used as a message header for syslogging it """
    # build syslog 'priority'
    pri =  "<%d>" % (syslog.LOG_USER + syslog.LOG_INFO)
    # build syslog formatted date
    localtime = time.localtime()
    day = time.strftime("%d", localtime)
    if day[0] == "0":
        day = " " + day[1:]  # syslog RFC says this MUST be a space
    val = time.strftime("%b %%s %H:%M:%S", localtime)
    date = val % day 
    # put it all together
    return "%s%s %s %s: " % (pri, date, host, program)

DATE_FMT = "%04d-%02d-%02dT%02d:%02d:%02d"
def formatDate(t):
    gmtm = time.gmtime(t)
    usec = int((t - int(t)) * 1000000 + 0.5)
    return "%s.%06dZ" % (DATE_FMT % gmtm[0:6], usec)

def log(event, level="Info", **kw):
    curtm = time.time()
    ts = formatDate(time.time())
    line = "ts=%s event=log_generator.%s level=%s guid=%s" % (
        ts, event, level, guid)
    line += ''.join([" %s=%s" % i for i in kw.items()])
    hdr = _syslogHeader()
    _sock.sendto(hdr + line + "\n", (SYSLOG_HOST, SYSLOG_PORT))

def run_ws():
    os.system('/opt/globus-dev/bin/globusrun-ws -submit -f /scratch/osg-demo/job.xml')
    #os.system('/opt/globus-dev/bin/globusrun-ws -submit -c /bin/false')

def run_gridftp(inF, outF):
    os.system('/opt/globus-dev/bin/globus-url-copy %s %s' % (inF, outF))

def main():
    global guid
    if len(sys.argv) > 1:
        guid = sys.argv[1]
    else:
        guid = str(uuid.uuid4())
    random.seed()
    while True:
        print "running gridftp"
        log('start-transfer-in')
        run_gridftp('gsiftp://schlitz.lbl.gov/scratch/osg-demo/fake_job.py', \
                'gsiftp://pabst.lbl.gov/scratch/osg-demo/fake_job.py')
        log('stop-transer-in')
        print 'running ws-gram job submission'
        log('start-job')
        run_ws()
        log('stop-job')
        print "running gridftp"
        log('start-transfer-out')
        run_gridftp('gsiftp://pabst.lbl.gov/scratch/osg-demo/output.txt', \
                'gsiftp://schlitz.lbl.gov/scratch/osg-demo/output.txt')
        log('stop-transer-out')
        time.sleep(random.randint(0,5))

if __name__ == '__main__':
    main()

