try:
    from setuptools import setup, Extension # now we can make eggs!
except ImportError:
    from distutils.core import setup, Extension
from glob import glob
import os
import sys

VERSION = '4.1.0'

# Extension modules
# -----------------
pmdir = lambda f: os.path.join('netlogger','parsers','modules', f)
ks_ext = Extension(pmdir('_ks'), sources=map(pmdir, ('ks_wrap.c', 'ks.c')))

# swig pseudo-target
# ------------------
# For development: build and install new version
# of library in the source tree
#
if 'swig' in sys.argv:
    if '--help' in sys.argv or '-h' in sys.argv:
        sys.stderr.write("swig pseudo-target takes no options\n"
                         "usage: setup.py swig\n")
        sys.exit(0)
    import subprocess
    ks_i = pmdir('ks.i')
    cmds = [("Manually re-generate the wrappers", ('swig','-python', ks_i)),
            ("Build the extension",('python', 'setup.py', 'build_ext', 
                                    '--inplace')),
            ("Move library",('/bin/mv', '_ks.so',pmdir('')))]
    for desc, args in cmds:
        print "--> %s: %s" % (desc, ' '.join(args))
        retcode = subprocess.call(args)
        if retcode != 0:
            sys.stderr.write("Command failed\n")
            sys.exit(1)
    print "Done"
    sys.exit(0)

# snapshot pseudo-target
# -------------------
# Change VERSION to current date and svn
# revisionand then
# replace 'snapshot' with 'sdist' and continue.
#
if 'snapshot' in sys.argv:
    import time, subprocess, re
    date = time.strftime("%Y%m%d")
    proc = subprocess.Popen("svn update", stdout=subprocess.PIPE, shell=True)
    s = proc.stdout.readline()
    rev = re.search("revision (\d+)", s).group(1)
    VERSION = "%sr%s" % (date, rev)
    sys.argv[sys.argv.index('snapshot')] = 'sdist'

# Main function
# -------------

setup(name = "netlogger", 
       version=VERSION,
       packages = ["netlogger","netlogger.parsers", 
                   "netlogger.parsers.modules", "netlogger.analysis",
                   "netlogger.analysis.query"],
      ext_modules = [ks_ext],
       package_data = {'netlogger':["analysis/schema.conf"]},
       scripts = glob('scripts/nl_*') + ['scripts/netlogd'] + glob('scripts/nagios/nl_*'),
       install_requires=["magicdate >= 0.1.2" ],
       # metadata for upload to PyPI
       author = "Dan Gunter",
       author_email = "dkgunter@lbl.gov",
       maintainer = "Dan Gunter",
       maintainer_email = "dkgunter@lbl.gov",
       description = "NetLogger Toolkit",
       long_description = """The NetLogger Toolkit is aimed at the task of monitoring and debugging distributed applications. NetLogger is both a methodology for analyzing distributed systems, and a set of tools to help implement the methodology.""",
       license = "LBNL. See http://acs.lbl.gov/NetLoggerWiki/index.php/NetLogger_License",
       keywords = "NetLogger log logging",
       url = "http://acs.lbl.gov/NetLoggerWiki/", 
       test_suite = "netlogger.tests.testAll.suite",
       classifiers = [
           "Development Status :: 5 - Production/Stable",
           "Environment :: MacOS X",
           "Environment :: No Input/Output (Daemon)",
           "Intended Audience :: Science/Research",
           "Intended Audience :: System Administrators",
           "License :: Other/Proprietary License",
           "Natural Language :: English",
           "Operating System :: POSIX",
           "Programming Language :: Python",
           "Topic :: Database",
           "Topic :: System :: Logging",
           "Topic :: System :: Monitoring",
           ],
)
