# Create your views here.

from django.core.cache import cache
from django.shortcuts import render_to_response
from nl.models import *
from nl.FilterForm import *
import datetime


def attr(request):
    qs = Attr.objects.all()[100]
    return render_to_response('nl/attr.html', {'queryset':qs})

def event(request, num=100):
    # this is the list of columns which the user wants to be displayed
    col_list = request.POST.lists()[0][1]

    # create a ValueQuerySet containing all fields in event table
    qs = Event.objects.values()[0:num]
    
    return render_to_response('nl/event.html', {'queryset':ll})


## for the moment, assume the default DB configuration. Return a page that looks like:
#
# run   timerange  user   #errors
# usc1  a - b         joe     20
# ucs2 ...
#
    
    


def summary(request):

    workflowhash = cache.get('workflowhash')
    e = cache.get('events')
    if workflowhash is not None and e is not None :
        e_fail = e.exclude(attr__value='0')
        e_success = e.filter(attr__value='0')
        return render_to_response('nl/summary.html',{'failed':len(e_fail), 'success':len(e_success), 'workflows':workflowhash})

    e = Event.objects.filter(attr__name='status')
    print 'got events'
    w = getWorkflows()
    print 'got workflows'

    e_fail = e.exclude(attr__value='0')
   # e_success = e.filter(attr__value='0')

    fail = len(e_fail)
    success = len(e) - fail
    
    workflowhash = {}

    for wf in w :
        print 'next workflow'
        ### get all events for this workflow
        evts = e.filter(ident__value=wf)
        print 'got workflow events'

     ## jobs per day
    ## make a list of tuples - datetime and event
        days = [(convertTimeToDate(evt.time), evt) for evt in evts]
        dayhash = {}
        for day in days :
            if (day[0].year, day[0].month, day[0].day) not in dayhash :
                dayhash[(day[0].year, day[0].month, day[0].day)] = [day[1]]
            else :
                dayhash[(day[0].year, day[0].month, day[0].day)].append(day[1])


    ### get counts per day
        counts = {}
        for day in dayhash :
            counts[day] = len(dayhash[day])

    ### cumulative running time. Need tio use the Attr table for
    ### this. This shopuld probably be a one-to-many relationship.
    #    attribs = Attr.objects.all()
     #   ctime = sum([float(x.value) for x in attribs if x.name == 'duration'])


    ### cumulative running time per day
        runtime = {}
#        for day in dayhash :
#            rtime = 0
#            for evt in dayhash[day] :
#                attribs = evt.attr_set.filter(name='duration')
#                try :
#                    rtime += float(attribs[0].value)
#                except :
#                    print 'attrib error', attribs
#                    continue
#            runtime[day] = rtime
#        ctime = sum(runtime.values())
        ctime = 0

   ### jobs per host:
        hosthash = {}  
#    hosts = set([evt.attr_set.filter(name='host')[0].value for evt in e])
#        for evt in evts :
#            host = evt.attr_set.filter(name='host')[0].value
#            if host not in hosthash :
#                hosthash[host] = [evt]
 #           else :
 #               hosthash[host].append(evt)

        workflowhash[wf] = (dayhash, counts, ctime, runtime, hosthash)

    print 'cacheing'
    cache.set('events',e)
    cache.set('workflowhash',workflowhash)

    return render_to_response('nl/summary.html',{'failed':fail, 'success':success, 'workflows':workflowhash})

#'njobs':counts,'ctime':ctime,
#    'runtime':runtime, 'hostjobs':hosthash, 'typejobs':{}, ;'workflows', w} )

def failed(request):
    e = Event.objects.filter(attr__name='status').exclude(attr__value='0')

    return render_to_response('nl/failed.html', {'fail':e}, )


def succeeded(request):
    e = Event.objects.filter(attr__name='status', attr__value='0')
    return render_to_response('nl/succeed.html', {'succeed':e}, )



def user(request, user):
    user_event = Event.objects.filter(attr__name='user', attr__value=user)      
    return render_to_response('nl/user.html',{'user_event':user_event})

def host(request, host):
    host_event = Event.objects.filter(attr__name='host', attr__value=host)      
    return render_to_response('nl/host.html',{'host_event':host_event})

def type(request, type):
    type_event = Event.objects.filter(attr__name='type', attr__value=type)         
    return render_to_response('nl/type.html',{'type_event':type_event})


## helper fns
def convertTimeToDate(timeval) :
    return datetime.date.fromtimestamp(timeval)
    

def getWorkflows() :
    return set([x.value for x in Ident.objects.filter(name='workflow')])
