# Create your views here.

from django.shortcuts import render_to_response
from netlogger.pegasus.nl_troubleshooting import *

def Tasks(request, run_id, task_id) :
    t = task(run_id, int(task_id))

    return render_to_response('xml/task.xml', {'task':t})

def FailedTasks(request, run_id) :
    tasklist = getFailedTasks(run_id)
    return render_to_response('xml/tasklist.xml', {'tasklist':tasklist})


def Mappings(request, run_id) :
    mappings = getMappings(run_id)
    return render_to_response('xml/maplist.xml', {'maplist':mappings})
    

def Children(request, run_id, task_id) :
    t = task(run_id, int(task_id))
    kids = t.getChildren()
    return render_to_response('xml/tasklist.xml', {'tasklist' : kids})

def Parents(request, run_id, task_id) :
    t = task(run_id, int(task_id))
    plist = t.getParents()
    return render_to_response('xml/tasklist.xml', {'tasklist' : plist})


